/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.dbeaver.ee.mongodb.model.MGCollection;
import com.dbeaver.ee.mongodb.model.MGCollectionAttribute;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public class MGIndex
implements DBSTableIndex {
    private final MGCollection table;
    private final DBObject metadata;
    private List<IndexColumn> columns = new ArrayList<IndexColumn>();
    private boolean primary;

    public MGIndex(DBRProgressMonitor monitor, MGCollection table, DBObject metadata) throws DBException {
        this.table = table;
        this.metadata = metadata;
        Map key = (Map)metadata.get("key");
        for (Map.Entry entry : key.entrySet()) {
            String name = (String)entry.getKey();
            boolean asc = CommonUtils.toInt(entry.getValue()) == 1;
            this.columns.add(new IndexColumn(name, asc));
        }
        this.primary = this.columns.size() == 1 && this.columns.get(0).getName().equals("_id");
    }

    public DBSTable getContainer() {
        return this.table;
    }

    public DBSTable getTable() {
        return this.table;
    }

    public boolean isUnique() {
        return this.primary;
    }

    public boolean isPrimary() {
        return false;
    }

    public DBSIndexType getIndexType() {
        return DBSIndexType.UNKNOWN;
    }

    public List<IndexColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DBSEntity getParentObject() {
        return this.table;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.INDEX;
    }

    @NotNull
    public String getName() {
        return (String)this.metadata.get("name");
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.getName();
    }

    public class IndexColumn
    implements DBSTableIndexColumn {
        private final String name;
        private final boolean asc;

        public IndexColumn(String name, boolean asc) {
            this.name = name;
            this.asc = asc;
        }

        @Nullable
        public DBSEntityAttribute getAttribute() {
            return MGIndex.this.table.getAttribute((DBRProgressMonitor)new VoidProgressMonitor(), this.name);
        }

        public DBSObject getParentObject() {
            return MGIndex.this;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return MGIndex.this.getDataSource();
        }

        @Property(viewable=true, editable=true, order=1)
        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isPersisted() {
            return true;
        }

        public String getDescription() {
            return null;
        }

        @NotNull
        public DBSTableIndex getIndex() {
            return MGIndex.this;
        }

        public int getOrdinalPosition() {
            return 0;
        }

        @Property(viewable=true, editable=true, order=2)
        public boolean isAscending() {
            return this.asc;
        }

        @Nullable
        public MGCollectionAttribute getTableColumn() {
            return MGIndex.this.table.getAttribute((DBRProgressMonitor)new VoidProgressMonitor(), this.name);
        }
    }
}

