/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditPartFactory;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.editor.VQBSelectionTool;
import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.utils.CommonUtils;

public class VQBEditorDecorator
extends ERDDecoratorDefault {
    private static final Log log = Log.getLog(VQBEditorDecorator.class);
    private final VQBEditorPart editorPart;

    public VQBEditorDecorator(VQBEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public boolean showCheckboxes() {
        return true;
    }

    public boolean allowEntityDuplicates() {
        return true;
    }

    public boolean supportsAttributeVisibility() {
        return false;
    }

    public Insets getDefaultEntityInsets() {
        return new Insets(30, 40, 20, 40);
    }

    public EditPartFactory createPartFactory() {
        return new VQBEditPartFactory();
    }

    public void fillPalette(PaletteRoot paletteRoot, boolean readOnly) {
        PaletteDrawer toolsDrawer = this.createToolsDrawer(paletteRoot);
        SelectionToolEntry selectionTool = new SelectionToolEntry();
        selectionTool.setToolClass(VQBSelectionTool.class);
        toolsDrawer.add((PaletteEntry)selectionTool);
        CreationFactory factory = new CreationFactory(){

            public Object getNewObject() {
                return new ERDEntity(VQBEditorDecorator.this.editorPart.getDataSource());
            }

            public Object getObjectType() {
                return "create child";
            }
        };
        CreationToolEntry tableAddTool = new CreationToolEntry("Add Table", "Add joined table", factory, DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE));
        toolsDrawer.add((PaletteEntry)tableAddTool);
        paletteRoot.setDefaultEntry((ToolEntry)selectionTool);
    }

    public void fillEntityFromObject(DBRProgressMonitor monitor, EntityDiagram diagram, List<ERDEntity> otherEntities, ERDEntity erdEntity) {
        super.fillEntityFromObject(monitor, diagram, otherEntities, erdEntity);
        if (erdEntity.getUserData() == null) {
            DBSEntity entity = (DBSEntity)erdEntity.getObject();
            DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)entity);
            DBSSchema schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)entity);
            String fullName = DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
            VQBQueryInfo queryInfo = this.editorPart.getQueryInfo();
            Table fromItem = new Table();
            fromItem.setName(DBUtils.getQuotedIdentifier((DBSObject)entity));
            if (schema != null) {
                fromItem.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)schema));
            } else if (catalog != null) {
                fromItem.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)catalog));
            }
            if (schema != null && catalog != null && fullName.startsWith(DBUtils.getQuotedIdentifier((DBSObject)catalog))) {
                fromItem.setDatabase(new Database(catalog.getName()));
            }
            if (VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.add.aliases.always")) {
                String entityAlias = VQBUtils.generateEntityAlias(diagram, otherEntities, entity);
                erdEntity.setAlias(entityAlias);
                Alias alias = new Alias(entityAlias);
                alias.setUseAs(false);
                fromItem.setAlias(alias);
            }
            erdEntity.setUserData((Object)fromItem);
            PlainSelect plainSelect = queryInfo.getPlainSelect();
            if (plainSelect != null && plainSelect.getFromItem() == null) {
                plainSelect.setFromItem((FromItem)fromItem);
                erdEntity.setPrimary(true);
            }
        }
    }

    public ERDAssociation createAutoAssociation(ERDContainer diagram, DBSEntityAssociation association, ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        PlainSelect plainSelect;
        if (sourceEntity.hasAssociationsWith((ERDElement)targetEntity) || targetEntity.hasAssociationsWith((ERDElement)sourceEntity)) {
            return null;
        }
        if (sourceEntity == targetEntity) {
            return null;
        }
        boolean reverseAssoc = false;
        if (targetEntity.isPrimary() || !CommonUtils.isEmpty((Collection)targetEntity.getReferences()) || !CommonUtils.isEmpty((Collection)targetEntity.getAssociations())) {
            if (!CommonUtils.isEmpty((Collection)sourceEntity.getReferences())) {
                log.debug((Object)("Both entities '" + sourceEntity.getName() + "' and '" + targetEntity.getName() + "' already participate in statement"));
                return null;
            }
            ERDEntity tmp = sourceEntity;
            sourceEntity = targetEntity;
            targetEntity = tmp;
            reverseAssoc = true;
        }
        ERDJoin erdJoin = new ERDJoin(sourceEntity, targetEntity, reflect);
        if (association instanceof DBSEntityReferrer) {
            try {
                List attrRefs = ((DBSEntityReferrer)association).getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
                if (!CommonUtils.isEmpty((Collection)attrRefs)) {
                    for (DBSEntityAttributeRef attrRef : attrRefs) {
                        if (!(attrRef instanceof DBSTableForeignKeyColumn)) continue;
                        DBSEntityAttribute targetAttr = ((DBSTableForeignKeyColumn)attrRef).getReferencedColumn();
                        DBSEntityAttribute sourceAttr = attrRef.getAttribute();
                        if (reverseAssoc) {
                            DBSEntityAttribute tmp = targetAttr;
                            targetAttr = sourceAttr;
                            sourceAttr = tmp;
                        }
                        if (sourceAttr == null || targetAttr == null) continue;
                        ERDEntityAttribute erdSourceAttr = ERDUtils.getAttributeByModel((ERDEntity)sourceEntity, (DBSEntityAttribute)sourceAttr);
                        ERDEntityAttribute erdTargetAttr = ERDUtils.getAttributeByModel((ERDEntity)targetEntity, (DBSEntityAttribute)targetAttr);
                        if (erdSourceAttr == null || erdTargetAttr == null) continue;
                        erdJoin.addCondition(erdSourceAttr, erdTargetAttr);
                    }
                }
            }
            catch (DBException e) {
                log.error((Object)"Error resolving ERD association attributes", (Throwable)e);
            }
        }
        if ((plainSelect = this.editorPart.getQueryInfo().getPlainSelect()) != null) {
            Join join = VQBUtils.findEntityJoin(this.editorPart.getDiagram(), plainSelect, null, targetEntity);
            if (join == null) {
                join = erdJoin.createStatementJoin();
                VQBUtils.getQueryJoins(plainSelect).add(join);
            } else {
                erdJoin.updateStatementJoin(join);
            }
        }
        return erdJoin;
    }
}

