/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.maxdb.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.maxdb.database.MaxDBDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropDefaultValueGenerator;
import liquibase.statement.core.DropDefaultValueStatement;
import liquibase.structure.DatabaseObject;

public class DropDefaultValueGeneratorMaxDB
extends DropDefaultValueGenerator {
    public boolean supports(DropDefaultValueStatement statement, Database database) {
        return database instanceof MaxDBDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public Sql[] generateSql(DropDefaultValueStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " COLUMN  " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " DROP DEFAULT";
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }
}

