/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public class ERDEntity
extends ERDElement<DBSEntity> {
    static final Log log = Log.getLog(ERDEntity.class);
    private DBPDataSource dataSource;
    private String alias;
    private List<ERDEntityAttribute> attributes;
    private List<DBSEntityAssociation> unresolvedKeys;
    private boolean primary = false;
    private ERDAttributeVisibility attributeVisibility;

    public ERDEntity(DBPDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ERDEntity(DBSEntity entity) {
        super(entity);
    }

    public DBPDataSource getDataSource() {
        return this.dataSource != null ? this.dataSource : ((DBSEntity)this.getObject()).getDataSource();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ERDAttributeVisibility getAttributeVisibility() {
        return this.attributeVisibility;
    }

    public void setAttributeVisibility(ERDAttributeVisibility attributeVisibility) {
        this.attributeVisibility = attributeVisibility;
    }

    public void addAttribute(ERDEntityAttribute attribute, boolean reflect) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ERDEntityAttribute>();
        }
        if (this.attributes.contains(attribute)) {
            throw new IllegalArgumentException("Attribute already present");
        }
        this.attributes.add(attribute);
        if (reflect) {
            this.firePropertyChange("CHILD", null, attribute);
        }
    }

    public void removeAttribute(ERDEntityAttribute attribute, boolean reflect) {
        this.attributes.remove(attribute);
        if (reflect) {
            this.firePropertyChange("CHILD", attribute, null);
        }
    }

    public void switchAttribute(ERDEntityAttribute attribute, int index, boolean reflect) {
        this.attributes.remove(attribute);
        this.attributes.add(index, attribute);
        if (reflect) {
            this.firePropertyChange("REORDER", this, attribute);
        }
    }

    @NotNull
    public List<ERDEntityAttribute> getAttributes() {
        return CommonUtils.safeList(this.attributes);
    }

    @NotNull
    public List<ERDEntityAttribute> getCheckedAttributes() {
        ArrayList<ERDEntityAttribute> result = new ArrayList<ERDEntityAttribute>();
        if (this.attributes != null) {
            for (ERDEntityAttribute attr : this.attributes) {
                if (!attr.isChecked()) continue;
                result.add(attr);
            }
        }
        return result;
    }

    public void reloadAttributes(EntityDiagram diagram) {
        if (!CommonUtils.isEmpty(this.attributes)) {
            this.attributes.clear();
        }
        diagram.getDecorator().fillEntityFromObject((DBRProgressMonitor)new VoidProgressMonitor(), diagram, Collections.emptyList(), this);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void addModelRelations(DBRProgressMonitor monitor, ERDContainer diagram, boolean create, boolean reflect) {
        try {
            HashSet fkAttrs = new HashSet();
            List fks = DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)this.getObject()));
            if (fks != null) {
                for (DBSEntityAssociation fk : fks) {
                    ERDEntity entity2;
                    if (fk instanceof DBSEntityReferrer) {
                        fkAttrs.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)fk)));
                    }
                    if ((entity2 = diagram.getEntityMap().get(DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)fk.getAssociatedEntity()))) == null) {
                        if (this.unresolvedKeys == null) {
                            this.unresolvedKeys = new ArrayList<DBSEntityAssociation>();
                        }
                        this.unresolvedKeys.add(fk);
                        continue;
                    }
                    if (!create || DBUtils.isInheritedObject((Object)fk)) continue;
                    diagram.getDecorator().createAutoAssociation(diagram, fk, this, entity2, reflect);
                }
            }
            for (ERDEntityAttribute attribute : this.getAttributes()) {
                if (!fkAttrs.contains(attribute.getObject())) continue;
                attribute.setInForeignKey(true);
            }
        }
        catch (DBException e) {
            log.warn((Object)("Can't load table '" + ((DBSEntity)this.getObject()).getName() + "' foreign keys"), (Throwable)e);
        }
    }

    public void resolveRelations(ERDContainer diagram, boolean reflect) {
        if (CommonUtils.isEmpty(this.unresolvedKeys)) {
            return;
        }
        Iterator<DBSEntityAssociation> iter = this.unresolvedKeys.iterator();
        while (iter.hasNext()) {
            ERDAssociation erdAssociation;
            ERDEntity refEntity;
            DBSEntityAssociation fk = iter.next();
            if (fk.getReferencedConstraint() == null || (refEntity = diagram.getEntityMap().get(DBVUtils.tryGetRealEntity((DBSEntity)fk.getReferencedConstraint().getParentObject()))) == null || (erdAssociation = diagram.getDecorator().createAutoAssociation(diagram, fk, this, refEntity, reflect)) == null) continue;
            iter.remove();
        }
    }

    @NotNull
    public String getName() {
        return ((DBSEntity)this.getObject()).getName();
    }

    public String toString() {
        return String.valueOf(this.getName()) + (CommonUtils.isEmpty((String)this.alias) ? "" : " " + this.alias);
    }

    public int hashCode() {
        int aliasHC = this.alias == null ? 0 : this.alias.hashCode();
        return (this.object == null ? 0 : ((DBSEntity)this.object).hashCode()) + aliasHC;
    }

    public boolean equals(Object o) {
        if (o instanceof ERDEntity) {
            return CommonUtils.equalObjects((Object)this.object, (Object)((ERDEntity)o).object) && CommonUtils.equalObjects((Object)this.alias, (Object)((ERDEntity)o).alias);
        }
        return false;
    }
}

