/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.change;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddLookupTableChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.ext.teradata.database.TeradataDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class AddLookupTableChangeTeradata
extends AddLookupTableChange {
    protected String[] createSupportedDatabasesMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        return new String[]{"teradata"};
    }

    public boolean supports(Database database) {
        return database instanceof TeradataDatabase;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        String newTableCatalogName = this.getNewTableCatalogName() == null ? database.getDefaultCatalogName() : this.getNewTableCatalogName();
        String newTableSchemaName = this.getNewTableSchemaName() == null ? database.getDefaultSchemaName() : this.getNewTableSchemaName();
        String existingTableSchemaName = this.getExistingTableSchemaName() == null ? database.getDefaultSchemaName() : this.getExistingTableSchemaName();
        String existingTableCatalogName = this.getExistingTableCatalogName() == null ? database.getDefaultCatalogName() : this.getExistingTableCatalogName();
        SqlStatement[] createTablesSQL = new SqlStatement[]{new RawSqlStatement("CREATE TABLE " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " ( " + this.getNewColumnName() + " NOT NULL) AS (SELECT DISTINCT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL) WITH DATA")};
        statements.addAll(Arrays.asList(createTablesSQL));
        AddPrimaryKeyChange addPKChange = new AddPrimaryKeyChange();
        addPKChange.setSchemaName(newTableSchemaName);
        addPKChange.setTableName(this.getNewTableName());
        addPKChange.setColumnNames(this.getNewColumnName());
        statements.addAll(Arrays.asList(addPKChange.generateStatements(database)));
        AddForeignKeyConstraintChange addFKChange = new AddForeignKeyConstraintChange();
        addFKChange.setBaseTableSchemaName(existingTableSchemaName);
        addFKChange.setBaseTableName(this.getExistingTableName());
        addFKChange.setBaseColumnNames(this.getExistingColumnName());
        addFKChange.setReferencedTableSchemaName(newTableSchemaName);
        addFKChange.setReferencedTableName(this.getNewTableName());
        addFKChange.setReferencedColumnNames(this.getNewColumnName());
        addFKChange.setConstraintName(this.getFinalConstraintName());
        statements.addAll(Arrays.asList(addFKChange.generateStatements(database)));
        return statements.toArray(new SqlStatement[statements.size()]);
    }
}

