/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.Parameter;
import org.firebirdsql.gds.impl.DatabaseParameterBufferImp;
import org.firebirdsql.gds.ng.AbstractAttachProperties;
import org.firebirdsql.gds.ng.FbImmutableConnectionProperties;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class FbConnectionProperties
extends AbstractAttachProperties<IConnectionProperties>
implements IConnectionProperties {
    private static final Logger log = LoggerFactory.getLogger(FbConnectionProperties.class);
    private String databaseName;
    private short connectionDialect = (short)3;
    private int pageCacheSize;
    private boolean resultSetDefaultHoldable;
    private boolean columnLabelForName;
    private final DatabaseParameterBuffer extraDatabaseParameters = new DatabaseParameterBufferImp(DatabaseParameterBufferImp.DpbMetaData.DPB_VERSION_1, EncodingFactory.getPlatformEncoding());
    private FbImmutableConnectionProperties immutableConnectionPropertiesCache;

    public FbConnectionProperties(IConnectionProperties src) {
        super(src);
        if (src != null) {
            this.databaseName = src.getDatabaseName();
            this.connectionDialect = src.getConnectionDialect();
            this.pageCacheSize = src.getPageCacheSize();
            this.resultSetDefaultHoldable = src.isResultSetDefaultHoldable();
            this.columnLabelForName = src.isColumnLabelForName();
            for (Parameter parameter : src.getExtraDatabaseParameters()) {
                parameter.copyTo(this.extraDatabaseParameters, null);
            }
        }
    }

    public FbConnectionProperties() {
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        this.dirtied();
    }

    @Override
    public String getAttachObjectName() {
        return this.getDatabaseName();
    }

    @Override
    public short getConnectionDialect() {
        return this.connectionDialect;
    }

    @Override
    public void setConnectionDialect(short connectionDialect) {
        this.connectionDialect = connectionDialect;
        this.dirtied();
    }

    @Override
    public int getPageCacheSize() {
        return this.pageCacheSize;
    }

    @Override
    public void setPageCacheSize(int pageCacheSize) {
        this.pageCacheSize = pageCacheSize;
        this.dirtied();
    }

    @Override
    public void setResultSetDefaultHoldable(boolean holdable) {
        this.resultSetDefaultHoldable = holdable;
        this.dirtied();
    }

    @Override
    public boolean isResultSetDefaultHoldable() {
        return this.resultSetDefaultHoldable;
    }

    @Override
    public void setColumnLabelForName(boolean columnLabelForName) {
        this.columnLabelForName = columnLabelForName;
        this.dirtied();
    }

    @Override
    public boolean isColumnLabelForName() {
        return this.columnLabelForName;
    }

    @Override
    public DatabaseParameterBuffer getExtraDatabaseParameters() {
        return this.extraDatabaseParameters;
    }

    @Override
    public IConnectionProperties asImmutable() {
        if (this.immutableConnectionPropertiesCache == null) {
            this.immutableConnectionPropertiesCache = new FbImmutableConnectionProperties(this);
        }
        return this.immutableConnectionPropertiesCache;
    }

    @Override
    public IConnectionProperties asNewMutable() {
        return new FbConnectionProperties(this);
    }

    @Deprecated
    public void fromDpb(DatabaseParameterBuffer dpb) {
        block16: for (Parameter parameter : dpb) {
            switch (parameter.getType()) {
                case 28: {
                    this.setUser(parameter.getValueAsString());
                    continue block16;
                }
                case 29: {
                    this.setPassword(parameter.getValueAsString());
                    continue block16;
                }
                case 60: {
                    this.setRoleName(parameter.getValueAsString());
                    continue block16;
                }
                case 48: {
                    this.setEncoding(parameter.getValueAsString());
                    continue block16;
                }
                case 135: {
                    this.setCharSet(parameter.getValueAsString());
                    continue block16;
                }
                case 63: {
                    this.setConnectionDialect((short)parameter.getValueAsInt());
                    continue block16;
                }
                case 5: {
                    this.setPageCacheSize(parameter.getValueAsInt());
                    continue block16;
                }
                case 57: {
                    this.setConnectTimeout(parameter.getValueAsInt());
                    continue block16;
                }
                case 141: {
                    this.setSoTimeout(parameter.getValueAsInt());
                    continue block16;
                }
                case 129: {
                    this.setSocketBufferSize(parameter.getValueAsInt());
                    continue block16;
                }
                case 138: {
                    this.setResultSetDefaultHoldable(true);
                    continue block16;
                }
                case 142: {
                    this.setColumnLabelForName(true);
                    continue block16;
                }
                case 77: {
                    continue block16;
                }
                case 84: {
                    continue block16;
                }
            }
            log.warn(String.format("Unknown or unsupported parameter with type %d added to extra database parameters", parameter.getType()));
            parameter.copyTo(this.getExtraDatabaseParameters(), null);
            this.dirtied();
        }
    }

    @Override
    protected void dirtied() {
        this.immutableConnectionPropertiesCache = null;
    }
}

