/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;

public class DbAttachInfo {
    private String server = "localhost";
    private int port = 3050;
    private String fileName;

    private DbAttachInfo(String server, Integer port, String fileName, String originalConnectString) throws SQLException {
        if (fileName == null || fileName.equals("")) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(originalConnectString).messageParameter("null or empty database name in connection string").toFlatSQLException();
        }
        if (server != null) {
            this.server = server;
        }
        if (port != null) {
            this.port = port;
        }
        this.fileName = fileName;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static DbAttachInfo parseConnectString(String connectString) throws SQLException {
        if (connectString == null) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter("(null)").messageParameter("Connection string is missing").toFlatSQLException();
        }
        if ((connectString = connectString.trim()).startsWith("//")) {
            return DbAttachInfo.parseUrlConnectString(connectString.substring(2));
        }
        return DbAttachInfo.parseLegacyConnectString(connectString);
    }

    private static DbAttachInfo parseUrlConnectString(String connectString) throws SQLException {
        String server = null;
        String fileName = null;
        Integer port = null;
        int sep = connectString.indexOf(47);
        if (sep == 0 || sep == connectString.length() - 1) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Host separator: '/' at beginning or end").toFlatSQLException();
        }
        if (sep > 0) {
            server = connectString.substring(0, sep);
            fileName = connectString.substring(sep + 1);
            if (server.charAt(0) == '[') {
                int endIpv6Address = server.indexOf(93);
                if (endIpv6Address == -1) {
                    throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("IPv6 address expected, missing closing ']'").toFlatSQLException();
                }
                if (endIpv6Address != server.length() - 1) {
                    if (server.charAt(endIpv6Address + 1) == ':') {
                        port = DbAttachInfo.parsePortNumber(connectString, server.substring(endIpv6Address + 2));
                    } else {
                        throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Unexpected tokens '" + server.substring(endIpv6Address + 1) + "' after IPv6 address").toFlatSQLException();
                    }
                }
                server = server.substring(1, endIpv6Address);
            } else {
                int portSep = server.indexOf(58);
                if (portSep == 0 || portSep == server.length() - 1) {
                    throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Port separator: ':' at beginning or end of: " + server).toFlatSQLException();
                }
                if (portSep > 0) {
                    String portString = server.substring(portSep + 1);
                    port = DbAttachInfo.parsePortNumber(connectString, portString);
                    server = server.substring(0, portSep);
                }
            }
        } else if (sep == -1) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("null or empty database name in connection string").toFlatSQLException();
        }
        return new DbAttachInfo(server, port, fileName, connectString);
    }

    private static DbAttachInfo parseLegacyConnectString(String connectString) throws SQLException {
        char hostSepChar = ':';
        char portSepChar = '/';
        String server = null;
        String fileName = null;
        Integer port = null;
        int sep = connectString.indexOf(hostSepChar);
        if (sep == 0 || sep == connectString.length() - 1) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Host separator: '" + hostSepChar + "' at beginning or end").toFlatSQLException();
        }
        if (sep > 0) {
            server = connectString.substring(0, sep);
            fileName = connectString.substring(sep + 1);
            int portSep = server.indexOf(portSepChar);
            if (portSep == 0 || portSep == server.length() - 1) {
                throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Port separator: '" + portSepChar + "' at beginning or end of: " + server).toFlatSQLException();
            }
            if (portSep > 0) {
                String portString = server.substring(portSep + 1);
                port = DbAttachInfo.parsePortNumber(connectString, portString);
                server = server.substring(0, portSep);
            }
        } else if (sep == -1) {
            fileName = connectString;
        }
        return new DbAttachInfo(server, port, fileName, connectString);
    }

    private static int parsePortNumber(String connectString, String portString) throws SQLException {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Bad port: '" + portString + "' is not a number").cause(e).toFlatSQLException();
        }
    }
}

