/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Collections;
import java.util.List;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractTagFilter;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboTagFilter
extends AbstractTagFilter {
    private Combo combo;
    private String noSelectionLabel;
    private SelectionListener listener;

    @Override
    public void createControl(Composite parent) {
        if (this.getChoices() == null) {
            throw new IllegalStateException();
        }
        this.combo = new Combo(parent, 12);
        this.combo.setData((Object)this);
        this.listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ComboTagFilter.this.combo.getSelectionIndex();
                if (selectionIndex > 0) {
                    Tag tag = ComboTagFilter.this.getChoices().get(selectionIndex - 1);
                    ComboTagFilter.this.setSelected(Collections.singleton(tag));
                } else {
                    ComboTagFilter.this.setSelected(Collections.<Tag>emptySet());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.combo.addSelectionListener(this.listener);
        this.rebuildChoicesUi();
    }

    protected void rebuildChoicesUi() {
        if (this.combo != null) {
            this.combo.removeSelectionListener(this.listener);
            this.combo.removeAll();
            this.combo.add(this.noSelectionLabel == null ? "" : this.noSelectionLabel);
            if (this.getChoices() != null) {
                for (Tag tag : this.getChoices()) {
                    this.combo.add(tag.getLabel());
                }
            }
            this.combo.select(0);
            this.combo.addSelectionListener(this.listener);
        }
    }

    @Override
    protected void choicesChanged(List<Tag> choices, List<Tag> previousChoices) {
        this.rebuildChoicesUi();
        super.choicesChanged(choices, previousChoices);
    }

    public String getNoSelectionLabel() {
        return this.noSelectionLabel;
    }

    public void setNoSelectionLabel(String noSelectionLabel) {
        this.noSelectionLabel = noSelectionLabel;
    }

    @Override
    protected void updateUi() {
        if (this.combo.isDisposed()) {
            return;
        }
        int index = -1;
        if (!this.getSelected().isEmpty()) {
            Tag selected = this.getSelected().iterator().next();
            index = this.getChoices().indexOf(selected);
        }
        this.combo.select(index + 1);
        super.updateUi();
    }
}

