/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.grant.addgrant;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.grant.addgrant.GrantObjectPermissionStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class GrantObjectPermissionGenerator
extends AbstractSqlGenerator<GrantObjectPermissionStatement> {
    public Sql[] generateSql(GrantObjectPermissionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("GRANT ");
        sql.append(statement.getPermissionList());
        sql.append(" ON ");
        sql.append(database.escapeTableName(null, statement.getSchemaName(), statement.getObjectName()));
        sql.append(" TO ");
        sql.append(statement.getRecipientList());
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }

    public boolean supports(GrantObjectPermissionStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(GrantObjectPermissionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return statement.validate();
    }
}

