/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droptrigger;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.droptrigger.DropTriggerStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropTrigger", description="Drop trigger", priority=1)
public class DropTriggerChange
extends AbstractChange {
    private String triggerName;
    private String schemaName;

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getConfirmationMessage() {
        return "Trigger" + this.getTriggerName() + " has been droped";
    }

    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        DropTriggerStatement statement = new DropTriggerStatement(schemaName, this.getTriggerName());
        return new SqlStatement[]{statement};
    }
}

