/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.snapshot;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Scanner;
import java.util.TreeMap;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.BigIntType;
import liquibase.datatype.core.BlobType;
import liquibase.datatype.core.BooleanType;
import liquibase.datatype.core.CharType;
import liquibase.datatype.core.ClobType;
import liquibase.datatype.core.DateTimeType;
import liquibase.datatype.core.DateType;
import liquibase.datatype.core.DecimalType;
import liquibase.datatype.core.DoubleType;
import liquibase.datatype.core.FloatType;
import liquibase.datatype.core.IntType;
import liquibase.datatype.core.NCharType;
import liquibase.datatype.core.NVarcharType;
import liquibase.datatype.core.NumberType;
import liquibase.datatype.core.SmallIntType;
import liquibase.datatype.core.TimeType;
import liquibase.datatype.core.TimestampType;
import liquibase.datatype.core.TinyIntType;
import liquibase.datatype.core.VarcharType;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.snapshot.VerticaDatabaseSnapshot;
import liquibase.ext.vertica.structure.ColumnVertica;
import liquibase.ext.vertica.structure.Projection;
import liquibase.logging.LogFactory;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class ColumnVerticaSnapshotGenerator
extends JdbcSnapshotGenerator {
    public ColumnVerticaSnapshotGenerator() {
        super(ColumnVertica.class, new Class[]{Table.class, Projection.class});
    }

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase) {
            return 5;
        }
        return -1;
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Relation relation = ((Column)example).getRelation();
        Schema schema = relation.getSchema();
        List<CachedRow> columnMetadataRs = null;
        try {
            if (relation instanceof Projection) {
                VerticaDatabaseSnapshot verticaDatabaseSnapshot = new VerticaDatabaseSnapshot(new DatabaseObject[0], snapshot.getDatabase(), snapshot.getSnapshotControl());
                columnMetadataRs = verticaDatabaseSnapshot.getMetaData().getProjectionColumns(schema.getName(), relation.getName(), example.getName());
            }
            if (columnMetadataRs.size() > 0) {
                CachedRow data = (CachedRow)columnMetadataRs.get(0);
                return this.readColumn(data, relation, database);
            }
            return null;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(ColumnVertica.class)) {
            return;
        }
        if (foundObject instanceof Projection) {
            System.out.println("in vert col addTo, found: " + foundObject.getName());
            Database database = snapshot.getDatabase();
            Projection relation = (Projection)foundObject;
            List<CachedRow> allColumnsMetadataRs = null;
            try {
                VerticaDatabaseSnapshot verticaDatabaseSnapshot = new VerticaDatabaseSnapshot(new DatabaseObject[0], snapshot.getDatabase(), snapshot.getSnapshotControl());
                Schema schema = relation.getSchema();
                allColumnsMetadataRs = verticaDatabaseSnapshot.getMetaData().getProjectionColumns(schema.getName(), relation.getName(), null);
                for (CachedRow row : allColumnsMetadataRs) {
                    ColumnVertica exampleColumn = new ColumnVertica();
                    exampleColumn.setRelation(relation).setName(row.getString("COLUMN_NAME"));
                    relation.getColumns().add(exampleColumn);
                }
                String orderBy = this.createOrderByClause(allColumnsMetadataRs);
                relation.setOrderBy(orderBy);
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    protected String createOrderByClause(List<CachedRow> columnsMetadataRs) {
        TreeMap<Integer, String> sortPositionToColumnMap = new TreeMap<Integer, String>();
        for (CachedRow row : columnsMetadataRs) {
            Integer sortPosition = row.getInt("SORT_POSITION");
            if (sortPosition == null) continue;
            String columnName = row.getString("COLUMN_NAME");
            sortPositionToColumnMap.put(sortPosition, columnName);
        }
        StringBuilder orderBy = new StringBuilder();
        for (int i = 0; i < sortPositionToColumnMap.size(); ++i) {
            if (i > 0) {
                orderBy.append(",");
            }
            orderBy.append((String)sortPositionToColumnMap.get(i));
        }
        return orderBy.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ColumnVertica readColumn(CachedRow columnMetadataResultSet, Relation table, Database database) throws SQLException, DatabaseException {
        String rawProjectionName = null;
        rawProjectionName = table instanceof Projection ? (String)columnMetadataResultSet.get("PROJ_NAME") : (String)columnMetadataResultSet.get("TABLE_NAME");
        String rawColumnName = (String)columnMetadataResultSet.get("COLUMN_NAME");
        String rawSchemaName = StringUtils.trimToNull((String)((String)columnMetadataResultSet.get("TABLE_SCHEM")));
        String rawCatalogName = StringUtils.trimToNull((String)((String)columnMetadataResultSet.get("TABLE_CAT")));
        String remarks = StringUtils.trimToNull((String)((String)columnMetadataResultSet.get("REMARKS")));
        if (remarks != null) {
            remarks = remarks.replace("''", "'");
        }
        ColumnVertica column = new ColumnVertica();
        column.setName(rawColumnName);
        column.setRelation(table);
        column.setRemarks(remarks);
        Boolean nullable = columnMetadataResultSet.getBoolean("NULLABLE");
        if (nullable == null) {
            LogFactory.getLogger().info("Unknown nullable state for column " + column.toString() + ". Assuming nullable");
            column.setNullable(true);
        } else {
            column.setNullable(nullable);
        }
        String encoding = columnMetadataResultSet.getString("ENCODING");
        column.setEncoding(encoding);
        if (database.supportsAutoIncrement() && (table instanceof Table || table instanceof Projection)) {
            if (columnMetadataResultSet.containsColumn("IS_AUTOINCREMENT")) {
                Boolean isAutoincrement = (Boolean)columnMetadataResultSet.get("IS_AUTOINCREMENT");
                if (isAutoincrement == null) {
                    column.setAutoIncrementInformation(null);
                } else if (isAutoincrement.booleanValue()) {
                    column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                } else {
                    if (isAutoincrement.booleanValue()) throw new UnexpectedLiquibaseException("Unknown is_autoincrement value: '" + isAutoincrement + "'");
                    column.setAutoIncrementInformation(null);
                }
            } else {
                String selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawProjectionName, rawColumnName) + " from " + database.escapeTableName(rawCatalogName, rawSchemaName, rawProjectionName) + " where 0=1";
                LogFactory.getLogger().debug("Checking " + rawProjectionName + "." + rawCatalogName + " for auto-increment with SQL: '" + selectStatement + "'");
                Connection underlyingConnection = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
                Statement statement = null;
                ResultSet columnSelectRS = null;
                try {
                    statement = underlyingConnection.createStatement();
                    columnSelectRS = statement.executeQuery(selectStatement);
                    if (columnSelectRS.getMetaData().isAutoIncrement(1)) {
                        column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                    } else {
                        column.setAutoIncrementInformation(null);
                    }
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    if (columnSelectRS != null) {
                        columnSelectRS.close();
                    }
                }
            }
        }
        DataType type = this.readDataType(columnMetadataResultSet, column, database);
        column.setType(type);
        column.setDefaultValue(this.readDefaultValue(columnMetadataResultSet, column, database));
        return column;
    }

    protected DataType readDataType(CachedRow columnMetadataResultSet, Column column, Database database) throws SQLException {
        Integer decimalDigits;
        String columnTypeName = (String)columnMetadataResultSet.get("TYPE_NAME");
        DataType.ColumnSizeUnit columnSizeUnit = DataType.ColumnSizeUnit.BYTE;
        int dataType = columnMetadataResultSet.getInt("DATA_TYPE");
        Integer columnSize = columnMetadataResultSet.getInt("COLUMN_SIZE");
        if (database.dataTypeIsNotModifiable(columnTypeName)) {
            columnSize = null;
        }
        if ((decimalDigits = columnMetadataResultSet.getInt("DECIMAL_DIGITS")) != null && decimalDigits.equals(0)) {
            decimalDigits = null;
        }
        Integer radix = columnMetadataResultSet.getInt("NUM_PREC_RADIX");
        Integer characterOctetLength = columnMetadataResultSet.getInt("CHAR_OCTET_LENGTH");
        DataType type = new DataType(columnTypeName);
        type.setDataTypeId(Integer.valueOf(dataType));
        type.setColumnSize(columnSize);
        type.setDecimalDigits(decimalDigits);
        type.setRadix(radix);
        type.setCharacterOctetLength(characterOctetLength);
        type.setColumnSizeUnit(columnSizeUnit);
        return type;
    }

    protected Object readDefaultValue(CachedRow columnMetadataResultSet, Column columnInfo, Database database) throws SQLException, DatabaseException {
        Object val = columnMetadataResultSet.get("COLUMN_DEF");
        if (!(val instanceof String)) {
            return val;
        }
        String stringVal = (String)val;
        if (stringVal.isEmpty()) {
            return null;
        }
        if (stringVal.startsWith("'") && stringVal.endsWith("'")) {
            stringVal = stringVal.substring(1, stringVal.length() - 1);
        } else if (stringVal.startsWith("((") && stringVal.endsWith("))")) {
            stringVal = stringVal.substring(2, stringVal.length() - 2);
        } else if (stringVal.startsWith("('") && stringVal.endsWith("')")) {
            stringVal = stringVal.substring(2, stringVal.length() - 2);
        } else if (stringVal.startsWith("(") && stringVal.endsWith(")")) {
            return new DatabaseFunction(stringVal.substring(1, stringVal.length() - 1));
        }
        int type = Integer.MIN_VALUE;
        if (columnInfo.getType().getDataTypeId() != null) {
            type = columnInfo.getType().getDataTypeId();
        }
        String typeName = columnInfo.getType().getTypeName();
        Scanner scanner = new Scanner(stringVal.trim());
        try {
            LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().from(columnInfo.getType(), database);
            if (type == 2003) {
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof BigIntType || type == -5) {
                if (scanner.hasNextBigInteger()) {
                    return scanner.nextBigInteger();
                }
                return new DatabaseFunction(stringVal);
            }
            if (type == -2) {
                return new DatabaseFunction(stringVal.trim());
            }
            if (type == -7) {
                if (stringVal.startsWith("b'")) {
                    stringVal = stringVal.replaceFirst("b'", "").replaceFirst("'$", "");
                }
                stringVal = stringVal.trim();
                if (scanner.hasNextBoolean()) {
                    return scanner.nextBoolean();
                }
                return new Integer(stringVal);
            }
            if (liquibaseDataType instanceof BlobType || type == 2004) {
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof BooleanType || type == 16) {
                if (scanner.hasNextBoolean()) {
                    return scanner.nextBoolean();
                }
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof CharType || type == 1) {
                return stringVal;
            }
            if (liquibaseDataType instanceof ClobType || type == 2005) {
                return stringVal;
            }
            if (type == 70) {
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof DateType || type == 91) {
                if (typeName.equalsIgnoreCase("year")) {
                    return stringVal.trim();
                }
                if (this.zeroTime(stringVal)) {
                    return stringVal;
                }
                return new Date(this.getDateFormat(database).parse(stringVal.trim()).getTime());
            }
            if (liquibaseDataType instanceof DecimalType || type == 3) {
                if (scanner.hasNextBigDecimal()) {
                    return scanner.nextBigDecimal();
                }
                return new DatabaseFunction(stringVal);
            }
            if (type == 2001) {
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof DoubleType || type == 8) {
                if (scanner.hasNextDouble()) {
                    return scanner.nextDouble();
                }
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof FloatType || type == 6) {
                if (scanner.hasNextFloat()) {
                    return Float.valueOf(scanner.nextFloat());
                }
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof IntType || type == 4) {
                if (scanner.hasNextInt()) {
                    return scanner.nextInt();
                }
                return new DatabaseFunction(stringVal);
            }
            if (type == 2000) {
                return new DatabaseFunction(stringVal);
            }
            if (type == -16) {
                return stringVal;
            }
            if (type == -4) {
                return new DatabaseFunction(stringVal);
            }
            if (type == -1) {
                return stringVal;
            }
            if (liquibaseDataType instanceof NCharType || type == -15) {
                return stringVal;
            }
            if (type == 2011) {
                return stringVal;
            }
            if (type == 0) {
                return null;
            }
            if (liquibaseDataType instanceof NumberType || type == 2) {
                if (scanner.hasNextBigDecimal()) {
                    return scanner.nextBigDecimal();
                }
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof NVarcharType || type == -9) {
                return stringVal;
            }
            if (type == 1111) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 7) {
                return new BigDecimal(stringVal.trim());
            }
            if (type == 2006) {
                return new DatabaseFunction(stringVal);
            }
            if (type == -8) {
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof SmallIntType || type == 5) {
                if (scanner.hasNextInt()) {
                    return scanner.nextInt();
                }
                return new DatabaseFunction(stringVal);
            }
            if (type == 2009) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 2002) {
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof TimeType || type == 92) {
                if (this.zeroTime(stringVal)) {
                    return stringVal;
                }
                return new Time(this.getTimeFormat(database).parse(stringVal).getTime());
            }
            if (liquibaseDataType instanceof DateTimeType || liquibaseDataType instanceof TimestampType || type == 93) {
                if (this.zeroTime(stringVal)) {
                    return stringVal;
                }
                return new Timestamp(this.getDateTimeFormat(database).parse(stringVal).getTime());
            }
            if (liquibaseDataType instanceof TinyIntType || type == -6) {
                if (scanner.hasNextInt()) {
                    return scanner.nextInt();
                }
                return new DatabaseFunction(stringVal);
            }
            if (type == -3) {
                return new DatabaseFunction(stringVal);
            }
            if (liquibaseDataType instanceof VarcharType || type == 12) {
                return stringVal;
            }
            LogFactory.getLogger().info("Unknown default value: value '" + stringVal + "' type " + typeName + " (" + type + "), assuming it is a function");
            return new DatabaseFunction(stringVal);
        }
        catch (ParseException e) {
            return new DatabaseFunction(stringVal);
        }
    }

    private boolean zeroTime(String stringVal) {
        return stringVal.replace("-", "").replace(":", "").replace(" ", "").replace("0", "").equals("");
    }

    protected DateFormat getDateFormat(Database database) {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    protected DateFormat getTimeFormat(Database database) {
        return new SimpleDateFormat("HH:mm:ss");
    }

    protected DateFormat getDateTimeFormat(Database database) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

