/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis;

import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDataSource;
import com.dbeaver.ee.redis.model.RedisDatabase;
import com.dbeaver.ee.redis.model.RedisKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.commands.BasicCommands;
import redis.clients.jedis.commands.MultiKeyCommands;

public class RedisUtils {
    private static final Log log = Log.getLog(RedisUtils.class);
    public static final List<String> NULL_SUB_KEYS = Collections.emptyList();

    public static Map<String, Object> parseInfo(String info) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new StringReader(info));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty()) {
                        break;
                    }
                    int divPos = line.indexOf(58);
                    if (divPos == -1) continue;
                    String name = line.substring(0, divPos);
                    String value = line.substring(divPos + 1);
                    map.put(name, value);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static List<RedisKey> getKeys(@NotNull DBRProgressMonitor monitor, @NotNull RedisDatabase database, @Nullable RedisKey parent, @Nullable String pattern, boolean showHierarchy) throws DBCException {
        RedisDataSource dataSource = database.getDataSource();
        DBPConnectionConfiguration props = database.getDataSource().getContainer().getConnectionConfiguration();
        String divider = database.getDataSource().getKeyDivider();
        if (parent != null && !showHierarchy) {
            return Collections.emptyList();
        }
        int maxKeys = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.key.read.count"), (int)10000);
        int maxPatternRead = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.pattern.read.count"), (int)100000);
        dataSource.getDefaultObject();
        monitor.beginTask("Read keys", 1);
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)database, (String)"Read keys");
            try {
                RedisUtils.selectCurDatabase(session, database);
                ScanParams params = new ScanParams();
                String cursorPattern = null;
                String parentName = null;
                if (parent != null) {
                    parentName = parent.getFullyQualifiedName(DBPEvaluationContext.DML);
                    cursorPattern = String.valueOf(parentName) + divider;
                    cursorPattern = !CommonUtils.isEmpty((String)pattern) ? String.valueOf(cursorPattern) + pattern : String.valueOf(cursorPattern) + "*";
                } else if (!CommonUtils.isEmpty((String)pattern)) {
                    cursorPattern = pattern;
                }
                if (cursorPattern != null) {
                    params.match(cursorPattern);
                    params.count(Integer.valueOf(maxPatternRead));
                } else {
                    params.count(Integer.valueOf(maxKeys));
                }
                TreeMap<void, List<String>> keyMap = new TreeMap<void, List<String>>();
                int totalKeysRead = 0;
                int totalIterations = 0;
                String cursorId = "0";
                log.debug((Object)("Read Redis keys " + cursorPattern));
                while (!monitor.isCanceled()) {
                    ScanResult scanResult = null;
                    if (session.supportsCommands(MultiKeyCommands.class)) {
                        scanResult = session.getCommands(MultiKeyCommands.class).scan(cursorId, params);
                    } else if (dataSource.isUseCluster()) {
                        Map clusterNodes = dataSource.getJedisCluster().getClusterNodes();
                        for (JedisPool jedisPool : clusterNodes.values()) {
                            Throwable throwable2 = null;
                            Object var25_41 = null;
                            try (Jedis jedis = jedisPool.getResource();){
                                scanResult = jedis.scan(cursorId, params);
                                if (scanResult.getCursor().equals("0")) continue;
                                break;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                    } else {
                        throw new DBCException("Scan command not supported");
                    }
                    if (scanResult == null) break;
                    cursorId = scanResult.getCursor();
                    ++totalIterations;
                    List scanKeys = scanResult.getResult();
                    for (String string : scanKeys) {
                        void var22_33;
                        void var22_31;
                        String string2;
                        if (totalKeysRead++ >= maxKeys) break;
                        if (parent != null && showHierarchy && string.startsWith(parentName) && (string2 = string.substring(parentName.length())).startsWith(divider)) {
                            String string3 = string2.substring(divider.length());
                        }
                        int divPos = showHierarchy ? var22_31.indexOf(divider) : -1;
                        String subKey = null;
                        if (divPos != -1) {
                            subKey = var22_31.substring(divPos + 1);
                            String string4 = var22_31.substring(0, divPos);
                        }
                        if (subKey != null) {
                            ArrayList<String> subKeys = (ArrayList<String>)keyMap.get(var22_33);
                            if (subKeys == null || subKeys == NULL_SUB_KEYS) {
                                subKeys = new ArrayList<String>();
                                keyMap.put(var22_33, subKeys);
                            }
                            subKeys.add(subKey);
                            continue;
                        }
                        if (keyMap.containsKey(var22_33)) continue;
                        keyMap.put(var22_33, NULL_SUB_KEYS);
                    }
                    if (totalKeysRead++ >= maxKeys || cursorId.equals("0")) break;
                }
                log.debug((Object)("Read " + totalKeysRead + " keys in " + totalIterations + " iterations"));
                boolean readAll = totalKeysRead < maxKeys;
                ArrayList<RedisKey> keys = new ArrayList<RedisKey>();
                for (Map.Entry entry : keyMap.entrySet()) {
                    RedisKey redisKey = new RedisKey(database, parent, (String)entry.getKey(), !((List)entry.getValue()).isEmpty());
                    keys.add(redisKey);
                    if (!readAll) continue;
                    Collections.sort((List)entry.getValue());
                    redisKey.setSubKeys((List)entry.getValue(), divider);
                }
                ArrayList<RedisKey> arrayList = keys;
                if (session != null) {
                    session.close();
                }
                return arrayList;
            }
            catch (Throwable throwable4) {
                try {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error scanning Redis keys", e);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void selectCurDatabase(RedisSession session) {
        RedisUtils.selectCurDatabase(session, session.getDataSource().getDefaultObject());
    }

    public static void selectCurDatabase(RedisSession session, @Nullable RedisDatabase database) {
        if (database == null || database.getDataSource().getDatabases().size() < 2) {
            return;
        }
        if (session.supportsCommands(BasicCommands.class)) {
            session.getCommands(BasicCommands.class).select(database.getId());
        }
    }
}

