/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.LocationName;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public class Cluster {
    @Nonnull
    private final com.google.bigtable.admin.v2.Cluster stateProto;

    @InternalApi
    public static Cluster fromProto(com.google.bigtable.admin.v2.Cluster proto) {
        return new Cluster(proto);
    }

    private Cluster(@Nonnull com.google.bigtable.admin.v2.Cluster proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Name must be set");
        this.stateProto = proto;
    }

    public String getId() {
        ClusterName fullName = (ClusterName)Verify.verifyNotNull((Object)ClusterName.parse((String)this.stateProto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getCluster();
    }

    public String getInstanceId() {
        ClusterName fullName = (ClusterName)Verify.verifyNotNull((Object)ClusterName.parse((String)this.stateProto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public String getZone() {
        LocationName location = (LocationName)Verify.verifyNotNull((Object)LocationName.parse((String)this.stateProto.getLocation()));
        return location.getLocation();
    }

    public State getState() {
        return State.fromProto(this.stateProto.getState());
    }

    public int getServeNodes() {
        return this.stateProto.getServeNodes();
    }

    public StorageType getStorageType() {
        return StorageType.fromProto(this.stateProto.getDefaultStorageType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return Objects.equal((Object)this.stateProto, (Object)cluster.stateProto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.stateProto});
    }

    public static enum State {
        NOT_KNOWN(Cluster.State.STATE_NOT_KNOWN),
        READY(Cluster.State.READY),
        CREATING(Cluster.State.CREATING),
        RESIZING(Cluster.State.RESIZING),
        DISABLED(Cluster.State.DISABLED),
        UNRECOGNIZED(Cluster.State.UNRECOGNIZED);

        private final Cluster.State proto;

        @InternalApi
        public static State fromProto(Cluster.State proto) {
            for (State state : State.values()) {
                if (!state.proto.equals((Object)proto)) continue;
                return state;
            }
            return UNRECOGNIZED;
        }

        private State(Cluster.State proto) {
            this.proto = proto;
        }

        @InternalApi
        public Cluster.State toProto() {
            return this.proto;
        }
    }
}

