/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoResultIterable;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.paginators.ScanIterable;

public class DynamoScanStatement
extends DynamoBaseStatement {
    private final DynamoTable table;
    private ScanRequest scanRequest;
    private DBCExecutionSource source;
    protected Throwable executeError;
    protected long offset;
    protected long limit;
    private DynamoResultIterable resultSet;

    public DynamoScanStatement(DynamoSession session, DynamoTable table) {
        super(session);
        this.table = table;
    }

    public DynamoTable getTable() {
        return this.table;
    }

    public String getQueryString() {
        return "SCAN TABLE " + this.table.getName();
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public boolean executeStatement() throws DBCException {
        ScanRequest.Builder srBuilder = ScanRequest.builder().tableName(this.table.getName());
        if (this.limit > 0L) {
            srBuilder.limit(Integer.valueOf((int)this.limit));
        }
        ScanRequest scanRequest = (ScanRequest)srBuilder.build();
        ScanIterable scanResponses = this.table.getDataSource().getClient().scanPaginator(scanRequest);
        this.resultSet = new DynamoResultIterable(this, (Iterable<?>)scanResponses, this.limit);
        return true;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public DynamoResultIterable openResultSet() throws DBCException {
        return this.resultSet;
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return -1;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        blockThread.interrupt();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public String getEntityName() {
        return this.table.getName();
    }
}

