/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceOrigin;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.DataSourceSerializerLegacy;
import org.jkiss.dbeaver.registry.DataSourceSerializerModern;
import org.jkiss.dbeaver.registry.ProjectMetadata;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DataSourceRegistry
implements DBPDataSourceRegistry {
    @Deprecated
    public static final String DEFAULT_AUTO_COMMIT = "default.autocommit";
    @Deprecated
    public static final String DEFAULT_ISOLATION = "default.isolation";
    @Deprecated
    public static final String DEFAULT_ACTIVE_OBJECT = "default.activeObject";
    private static final long DISCONNECT_ALL_TIMEOUT = 5000L;
    private static final Log log = Log.getLog(DataSourceRegistry.class);
    public static final String OLD_CONFIG_FILE_NAME = "data-sources.xml";
    private final DBPPlatform platform;
    private final ProjectMetadata project;
    private final Map<IFile, DataSourceOrigin> origins = new LinkedHashMap<IFile, DataSourceOrigin>();
    private final List<DataSourceDescriptor> dataSources = new ArrayList<DataSourceDescriptor>();
    private final List<DBPEventListener> dataSourceListeners = new ArrayList<DBPEventListener>();
    private final List<DataSourceFolder> dataSourceFolders = new ArrayList<DataSourceFolder>();
    private final List<DBSObjectFilter> savedFilters = new ArrayList<DBSObjectFilter>();
    private final List<DBWNetworkProfile> networkProfiles = new ArrayList<DBWNetworkProfile>();
    private volatile boolean saveInProgress = false;

    public DataSourceRegistry(DBPPlatform platform, ProjectMetadata project) {
        this.platform = platform;
        this.project = project;
        this.loadDataSources(false);
        DataSourceProviderRegistry.getInstance().fireRegistryChange(this, true);
    }

    public DataSourceRegistry(DataSourceRegistry source, ProjectMetadata project, boolean copyDataSources) {
        this.platform = source.platform;
        this.project = project;
        if (copyDataSources) {
            for (DataSourceDescriptor ds : source.dataSources) {
                this.dataSources.add(new DataSourceDescriptor(ds, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DataSourceProviderRegistry.getInstance().fireRegistryChange(this, false);
        List<Object> list = this.dataSourceListeners;
        synchronized (list) {
            if (!this.dataSourceListeners.isEmpty()) {
                log.warn((Object)("Some data source listeners are still registered: " + this.dataSourceListeners));
            }
            this.dataSourceListeners.clear();
        }
        this.closeConnections(5000L);
        list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dataSourceDescriptor : this.dataSources) {
                dataSourceDescriptor.dispose();
            }
            this.dataSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections(long waitTime) {
        boolean hasConnections = false;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dataSource : this.dataSources) {
                if (!dataSource.isConnected()) continue;
                hasConnections = true;
                break;
            }
        }
        if (!hasConnections) {
            return;
        }
        DisconnectTask disconnectTask = new DisconnectTask();
        if (!RuntimeUtils.runTask((DBRRunnableWithProgress)disconnectTask, (String)"Disconnect from data sources", (long)waitTime)) {
            log.warn((Object)("Some data source connections wasn't closed on shutdown in " + waitTime + "ms. Probably network timeout occurred."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceOrigin getDefaultOrigin() {
        Map<IFile, DataSourceOrigin> map = this.origins;
        synchronized (map) {
            IFile legacyFile;
            for (DataSourceOrigin origin : this.origins.values()) {
                if (!origin.isDefault()) continue;
                return origin;
            }
            IFile defFile = this.getModernConfigFile();
            if (!defFile.exists() && (legacyFile = this.getLegacyConfigFile()).exists()) {
                defFile = legacyFile;
            }
            DataSourceOrigin origin = new DataSourceOrigin(defFile, true);
            this.origins.put(defFile, origin);
            return origin;
        }
    }

    private IFile getLegacyConfigFile() {
        return this.project.getEclipseProject().getFile(".dbeaver-data-sources.xml");
    }

    private IFile getModernConfigFile() {
        return this.project.getMetadataFolder(false).getFile("data-sources.json");
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(String id) {
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dsd : this.dataSources) {
                if (!dsd.getId().equals(id)) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(DBPDataSource dataSource) {
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dsd : this.dataSources) {
                if (dsd.getDataSource() != dataSource) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor findDataSourceByName(String name) {
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor dsd : this.dataSources) {
                if (!dsd.getName().equals(name)) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends DBPDataSourceContainer> getDataSourcesByProfile(@NotNull DBWNetworkProfile profile) {
        List dsCopy;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            dsCopy = CommonUtils.copyList(this.dataSources);
        }
        dsCopy.removeIf(ds -> !CommonUtils.equalObjects((Object)ds.getConnectionConfiguration().getUserProfileName(), (Object)profile.getProfileName()));
        return dsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSourceDescriptor> getDataSources() {
        List dsCopy;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            dsCopy = CommonUtils.copyList(this.dataSources);
        }
        dsCopy.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return dsCopy;
    }

    public DBPDataSourceContainer createDataSource(DBPDriver driver, DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptor(this, DataSourceDescriptor.generateNewId(driver), (DriverDescriptor)driver, connConfig);
    }

    public DBPDataSourceContainer createDataSource(DBPDataSourceContainer source) {
        DataSourceDescriptor newDS = new DataSourceDescriptor((DataSourceDescriptor)source);
        newDS.setId(DataSourceDescriptor.generateNewId(source.getDriver()));
        return newDS;
    }

    public List<DataSourceFolder> getAllFolders() {
        return this.dataSourceFolders;
    }

    public List<DataSourceFolder> getRootFolders() {
        ArrayList<DataSourceFolder> rootFolders = new ArrayList<DataSourceFolder>();
        for (DataSourceFolder folder : this.dataSourceFolders) {
            if (folder.getParent() != null) continue;
            rootFolders.add(folder);
        }
        return rootFolders;
    }

    public DataSourceFolder addFolder(DBPDataSourceFolder parent, String name) {
        DataSourceFolder folder = new DataSourceFolder(this, (DataSourceFolder)parent, name, null);
        this.dataSourceFolders.add(folder);
        return folder;
    }

    public void removeFolder(DBPDataSourceFolder folder, boolean dropContents) {
        DataSourceFolder folderImpl = (DataSourceFolder)folder;
        DataSourceFolder[] dataSourceFolderArray = folderImpl.getChildren();
        int n = dataSourceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder child = dataSourceFolderArray[n2];
            this.removeFolder(child, dropContents);
            ++n2;
        }
        DBPDataSourceFolder parent = folder.getParent();
        if (parent != null) {
            folderImpl.setParent(null);
        }
        for (DataSourceDescriptor ds : this.dataSources) {
            if (ds.getFolder() != folder) continue;
            if (dropContents) {
                this.removeDataSource(ds);
                continue;
            }
            ds.setFolder(parent);
        }
        this.dataSourceFolders.remove(folderImpl);
    }

    public DBPDataSourceRegistry createCopy(DBPProject project, boolean copyDataSources) {
        return new DataSourceRegistry(this, (ProjectMetadata)project, copyDataSources);
    }

    private DataSourceFolder findRootFolder(String name) {
        for (DataSourceFolder root : this.getRootFolders()) {
            if (!root.getName().equals(name)) continue;
            return root;
        }
        return null;
    }

    public DBPDataSourceFolder getFolder(String path) {
        return this.findFolderByPath(path, true);
    }

    DataSourceFolder findFolderByPath(String path, boolean create) {
        DataSourceFolder parent = null;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder folder;
            String name = stringArray[n2];
            DataSourceFolder dataSourceFolder = folder = parent == null ? this.findRootFolder(name) : parent.getChild(name);
            if (folder == null) {
                if (!create) {
                    log.warn((Object)("Folder '" + path + "' not found"));
                    break;
                }
                folder = this.addFolder(parent, name);
            }
            parent = folder;
            ++n2;
        }
        return parent;
    }

    void addDataSourceFolder(DataSourceFolder folder) {
        this.dataSourceFolders.add(folder);
    }

    @Nullable
    public DBSObjectFilter getSavedFilter(String name) {
        for (DBSObjectFilter filter : this.savedFilters) {
            if (!CommonUtils.equalObjects((Object)filter.getName(), (Object)name)) continue;
            return filter;
        }
        return null;
    }

    @NotNull
    public List<DBSObjectFilter> getSavedFilters() {
        return this.savedFilters;
    }

    public void updateSavedFilter(DBSObjectFilter filter) {
        DBSObjectFilter filterCopy = new DBSObjectFilter(filter);
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filter.getName())) {
                this.savedFilters.set(i, filterCopy);
                return;
            }
            ++i;
        }
        this.savedFilters.add(filterCopy);
    }

    public void removeSavedFilter(String filterName) {
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filterName)) {
                this.savedFilters.remove(i);
                continue;
            }
            ++i;
        }
    }

    void addSavedFilter(DBSObjectFilter filter) {
        this.savedFilters.add(filter);
    }

    @Nullable
    public DBWNetworkProfile getNetworkProfile(String name) {
        for (DBWNetworkProfile profile : this.networkProfiles) {
            if (!CommonUtils.equalObjects((Object)profile.getProfileName(), (Object)name)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    public List<DBWNetworkProfile> getNetworkProfiles() {
        return this.networkProfiles;
    }

    public void updateNetworkProfile(DBWNetworkProfile profile) {
        int i = 0;
        while (i < this.networkProfiles.size()) {
            if (CommonUtils.equalObjects((Object)this.networkProfiles.get(i).getProfileName(), (Object)profile.getProfileName())) {
                this.networkProfiles.set(i, profile);
                return;
            }
            ++i;
        }
        this.networkProfiles.add(profile);
    }

    public void removeNetworkProfile(DBWNetworkProfile profile) {
        this.networkProfiles.remove(profile);
    }

    void addNetworkProfile(DBWNetworkProfile profile) {
        this.networkProfiles.add(profile);
    }

    public void addDataSource(DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        this.addDataSourceToList(descriptor);
        if (!dataSource.isTemporary()) {
            this.saveDataSources();
        }
        this.notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)descriptor, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDataSourceToList(@NotNull DataSourceDescriptor descriptor) {
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            this.dataSources.add(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSource(@NotNull DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            this.dataSources.remove(descriptor);
        }
        if (!dataSource.isTemporary()) {
            this.saveDataSources();
        }
        try {
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)dataSource);
        }
        finally {
            descriptor.dispose();
        }
    }

    public void updateDataSource(DBPDataSourceContainer dataSource) {
        if (!dataSource.isTemporary()) {
            this.saveDataSources();
        }
        this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSource);
    }

    public void flushConfig() {
        this.saveDataSources();
    }

    public void refreshConfig() {
        if (!this.saveInProgress) {
            this.loadDataSources(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceListener(DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            this.dataSourceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDataSourceListener(DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            return this.dataSourceListeners.remove(listener);
        }
    }

    private void fireDataSourceEvent(DBPEvent.Action action, DBSObject object) {
        this.notifyDataSourceListeners(new DBPEvent(action, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataSourceListeners(final DBPEvent event) {
        ArrayList<DBPEventListener> listeners;
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            if (this.dataSourceListeners.isEmpty()) {
                return;
            }
            listeners = new ArrayList<DBPEventListener>(this.dataSourceListeners);
        }
        new Job("Notify datasource events"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (DBPEventListener listener : listeners) {
                    listener.handleDataSourceEvent(event);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @NotNull
    public ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node("dbeaver").node("datasources");
    }

    public static List<DBPDataSourceContainer> getAllDataSources() {
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject project : workspace.getProjects()) {
            DBPDataSourceRegistry registry;
            if (!project.isOpen() || (registry = project.getDataSourceRegistry()) == null) continue;
            result.addAll(registry.getDataSources());
        }
        return result;
    }

    private void loadDataSources(boolean refresh) {
        if (!this.project.isOpen()) {
            return;
        }
        this.savedFilters.clear();
        ParseResults parseResults = new ParseResults();
        try {
            IResource res;
            int n;
            int n2;
            IResource[] iResourceArray;
            boolean modernFormat = false;
            IFolder metadataFolder = this.project.getMetadataFolder(false);
            if (metadataFolder.exists()) {
                iResourceArray = metadataFolder.members(8);
                n2 = iResourceArray.length;
                n = 0;
                while (n < n2) {
                    res = iResourceArray[n];
                    if (res instanceof IFile && res.exists() && res.getName().startsWith("data-sources") && res.getName().endsWith(".json")) {
                        this.loadDataSources((IFile)res, refresh, true, parseResults);
                        modernFormat = true;
                    }
                    ++n;
                }
            }
            if (!modernFormat) {
                iResourceArray = this.project.getEclipseProject().members(8);
                n2 = iResourceArray.length;
                n = 0;
                while (n < n2) {
                    res = iResourceArray[n];
                    if (res instanceof IFile) {
                        IFile file = (IFile)res;
                        if (res.getName().startsWith(".dbeaver-data-sources") && res.getName().endsWith(".xml") && file.exists() && file.exists()) {
                            this.loadDataSources(file, refresh, false, parseResults);
                        }
                    }
                    ++n;
                }
                if (!this.origins.isEmpty()) {
                    this.flushConfig();
                }
            }
        }
        catch (CoreException e) {
            log.error((Object)"Error reading datasources configuration", (Throwable)e);
        }
        if (refresh) {
            for (DataSourceDescriptor ds : parseResults.updatedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)ds);
            }
            for (DataSourceDescriptor ds : parseResults.addedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)ds);
            }
            ArrayList<DataSourceDescriptor> removedDataSource = new ArrayList<DataSourceDescriptor>();
            for (DataSourceDescriptor ds : this.dataSources) {
                if (parseResults.addedDataSources.contains(ds) || parseResults.updatedDataSources.contains(ds)) continue;
                removedDataSource.add(ds);
            }
            for (DataSourceDescriptor ds : removedDataSource) {
                this.dataSources.remove(ds);
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)ds);
                ds.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSources(IFile fromFile, boolean refresh, boolean modern, ParseResults parseResults) {
        DataSourceOrigin origin;
        boolean extraConfig = !fromFile.getName().equalsIgnoreCase(modern ? "data-sources.json" : ".dbeaver-data-sources.xml");
        Object object = this.origins;
        synchronized (object) {
            origin = this.origins.get(fromFile);
            if (origin == null) {
                origin = new DataSourceOrigin(fromFile, !extraConfig);
                this.origins.put(fromFile, origin);
            }
        }
        if (!fromFile.exists()) {
            return;
        }
        try {
            object = null;
            Object var8_10 = null;
            try (InputStream is = fromFile.getContents(true);){
                DataSourceSerializer serializer = modern ? new DataSourceSerializerModern(this) : new DataSourceSerializerLegacy(this);
                serializer.parseDataSources(is, origin, refresh, parseResults);
                this.updateProjectNature();
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error loading datasource config from " + fromFile.getFullPath()), (Throwable)ex);
        }
    }

    private void saveDataSources() {
        this.updateProjectNature();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        this.saveInProgress = true;
        try {
            for (DataSourceOrigin origin : this.origins.values()) {
                List<DataSourceDescriptor> localDataSources = this.getDataSources(origin);
                IFile configFile = origin.getSourceFile();
                if (origin.isDefault()) {
                    configFile = this.project.getFormat() == ProjectMetadata.ProjectFormat.MODERN ? this.getModernConfigFile() : this.getLegacyConfigFile();
                } else if (configFile.getName().startsWith(".dbeaver-data-sources") && "xml".equals(configFile.getFileExtension())) {
                    String newFileName = "data-sources" + configFile.getName().substring(".dbeaver-data-sources".length());
                    int divPos = newFileName.lastIndexOf(".");
                    newFileName = String.valueOf(newFileName.substring(0, divPos)) + ".json";
                    configFile = this.project.getMetadataFolder(false).getFile(newFileName);
                }
                try {
                    File plainConfigFile = configFile.getLocation().toFile();
                    IOUtils.makeFileBackup((File)plainConfigFile);
                    if (localDataSources.isEmpty()) {
                        configFile.delete(true, false, monitor.getNestedMonitor());
                    } else {
                        DataSourceSerializer serializer = this.project.getFormat() == ProjectMetadata.ProjectFormat.LEGACY ? new DataSourceSerializerLegacy(this) : new DataSourceSerializerModern(this);
                        serializer.saveDataSources((DBRProgressMonitor)monitor, origin, localDataSources, configFile);
                    }
                    try {
                        this.getSecurePreferences().flush();
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error saving secured preferences", e);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Error saving datasources configuration", (Throwable)ex);
                }
            }
        }
        finally {
            this.saveInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSourceDescriptor> getDataSources(DataSourceOrigin origin) {
        ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
        List<DataSourceDescriptor> list = this.dataSources;
        synchronized (list) {
            for (DataSourceDescriptor ds : this.dataSources) {
                if (ds.getOrigin() != origin) continue;
                result.add(ds);
            }
        }
        return result;
    }

    private void updateProjectNature() {
        try {
            IProject eclipseProject = this.project.getEclipseProject();
            IProjectDescription description = eclipseProject.getDescription();
            if (description != null) {
                Object[] natureIds = description.getNatureIds();
                if (this.dataSources.isEmpty()) {
                    if (ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                        description.setNatureIds((String[])ArrayUtils.remove(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                        eclipseProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else if (!ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                    description.setNatureIds((String[])ArrayUtils.add(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                    try {
                        eclipseProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        log.debug((Object)"Can't set project nature", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    static boolean isUseSecuredPrefStorage() {
        return DBWorkbench.getPlatform().getSecureStorage().useSecurePreferences();
    }

    static boolean saveCredentialsInSecuredStorage(@NotNull DBPProject project, @Nullable DataSourceDescriptor dataSource, @Nullable String subNode, @Nullable String userName, @Nullable String password) {
        block7: {
            ISecurePreferences prefNode;
            block9: {
                block8: {
                    DBASecureStorage secureStorage = DBWorkbench.getPlatform().getSecureStorage();
                    ISecurePreferences iSecurePreferences = prefNode = dataSource == null ? project.getSecurePreferences() : dataSource.getSecurePreferences();
                    if (!secureStorage.useSecurePreferences()) {
                        prefNode.removeNode();
                        break block7;
                    }
                    if (subNode != null) {
                        String[] stringArray = subNode.split("/");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String nodeName = stringArray[n2];
                            prefNode = prefNode.node(nodeName);
                            ++n2;
                        }
                    }
                    prefNode.put("name", dataSource != null ? dataSource.getName() : project.getName(), false);
                    if (CommonUtils.isEmpty((String)userName)) break block8;
                    prefNode.put("user", userName, true);
                    return true;
                }
                prefNode.remove("user");
                if (CommonUtils.isEmpty((String)password)) break block9;
                prefNode.put("password", password, true);
                return true;
            }
            try {
                prefNode.remove("password");
            }
            catch (Throwable e) {
                log.error((Object)"Can't save password in secure storage", e);
            }
        }
        return false;
    }

    private void clearSecuredPasswords(DataSourceDescriptor dataSource) {
        try {
            dataSource.getSecurePreferences().removeNode();
        }
        catch (Throwable throwable) {
            log.debug((Object)("Error clearing '" + dataSource.getId() + "' secure storage"));
        }
    }

    public DBPProject getProject() {
        return this.project;
    }

    public String toString() {
        return String.valueOf(this.project.getName()) + " (" + this.getClass().getSimpleName() + ")";
    }

    private class DisconnectTask
    implements DBRRunnableWithProgress {
        boolean disconnected;

        private DisconnectTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            List dsSnapshot;
            List list = DataSourceRegistry.this.dataSources;
            synchronized (list) {
                dsSnapshot = CommonUtils.copyList((Collection)DataSourceRegistry.this.dataSources);
            }
            monitor.beginTask("Disconnect all databases", dsSnapshot.size());
            try {
                for (DataSourceDescriptor dataSource : dsSnapshot) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    if (dataSource.isConnected()) {
                        try {
                            monitor.subTask("Disconnect from [" + dataSource.getName() + "]");
                            this.disconnected = dataSource.disconnect(monitor);
                        }
                        catch (Exception ex) {
                            log.error((Object)("Can't shutdown data source '" + dataSource.getName() + "'"), (Throwable)ex);
                        }
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    static class ParseResults {
        Set<DataSourceDescriptor> updatedDataSources = new LinkedHashSet<DataSourceDescriptor>();
        Set<DataSourceDescriptor> addedDataSources = new LinkedHashSet<DataSourceDescriptor>();

        ParseResults() {
        }
    }
}

