/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLStringAggFunction
extends AggregateFunction {
    boolean isDistinct;
    Expression expression;
    Expression delimiter;
    ArrayList<Object> aggregateValues = new ArrayList();
    LinkedHashSet<Object> distinctAggregateValues = new LinkedHashSet();

    public SQLStringAggFunction(boolean bl, Expression expression, Expression expression2) {
        this.isDistinct = bl;
        this.expression = expression;
        this.delimiter = expression2;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        String string = null;
        Object object = map.get("@GROUPROWS");
        Object object2 = this.delimiter.eval(map);
        if (object != null) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                object = this.expression.eval((Map)list.get(i));
                if (object == null) continue;
                if (stringBuffer.length() > 0 && object2 != null) {
                    stringBuffer.append(object2.toString());
                }
                stringBuffer.append(object.toString());
            }
            string = stringBuffer.toString();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<Object> iterator = this.aggregateValues.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0 && object2 != null) {
                    stringBuffer.append(object2.toString());
                }
                stringBuffer.append(iterator.next().toString());
            }
            iterator = this.distinctAggregateValues.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0 && object2 != null) {
                    stringBuffer.append(object2.toString());
                }
                stringBuffer.append(iterator.next().toString());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("STRING_AGG(");
        if (this.isDistinct) {
            stringBuilder.append("DISTINCT ");
        }
        stringBuilder.append(this.expression);
        stringBuilder.append(", ");
        stringBuilder.append(this.delimiter);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.delimiter.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<String> aggregateColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expression.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.add(this);
        return linkedList;
    }

    @Override
    public void resetAggregateFunctions() {
        this.distinctAggregateValues.clear();
        this.aggregateValues.clear();
    }

    @Override
    public void processRow(Map<String, Object> map) throws SQLException {
        Object object = this.expression.eval(map);
        if (object != null) {
            if (this.isDistinct) {
                this.distinctAggregateValues.add(object);
            } else {
                this.aggregateValues.add(object);
            }
        }
    }
}

