/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.AsteriskExpression;
import org.relique.jdbc.csv.Expression;

class SQLCountFunction
extends AggregateFunction {
    HashSet<Object> distinctValues;
    Expression expression;
    int counter = 0;

    public SQLCountFunction(boolean bl, Expression expression) {
        if (bl) {
            this.distinctValues = new HashSet();
        }
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Integer n;
        Object object = map.get("@GROUPROWS");
        if (object != null) {
            List list = (List)object;
            if (this.distinctValues != null) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < list.size(); ++i) {
                    object = this.expression.eval((Map)list.get(i));
                    if (object == null) continue;
                    hashSet.add(object);
                }
                n = hashSet.size();
            } else {
                int n2 = 0;
                if (this.expression instanceof AsteriskExpression) {
                    n2 = list.size();
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        object = this.expression.eval((Map)list.get(i));
                        if (object == null) continue;
                        ++n2;
                    }
                }
                n = n2;
            }
        } else {
            n = this.distinctValues != null ? Integer.valueOf(this.distinctValues.size()) : Integer.valueOf(this.counter);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("COUNT(");
        if (this.distinctValues != null) {
            stringBuilder.append("DISTINCT ");
        }
        stringBuilder.append(this.expression);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        return new LinkedList<String>();
    }

    @Override
    public List<String> aggregateColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!(this.expression instanceof AsteriskExpression)) {
            linkedList.addAll(this.expression.usedColumns(set));
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.add(this);
        return linkedList;
    }

    @Override
    public void resetAggregateFunctions() {
        if (this.distinctValues != null) {
            this.distinctValues.clear();
        }
        this.counter = 0;
    }

    @Override
    public void processRow(Map<String, Object> map) throws SQLException {
        if (this.expression instanceof AsteriskExpression) {
            ++this.counter;
        } else {
            Object object = this.expression.eval(map);
            if (object != null) {
                ++this.counter;
                if (this.distinctValues != null) {
                    this.distinctValues.add(object);
                }
            }
        }
    }
}

