/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.RelopExpression;

class BetweenExpression
extends LogicalExpression {
    Expression obj;
    Expression left;
    Expression right;

    public BetweenExpression(Expression expression, Expression expression2, Expression expression3) {
        this.obj = expression;
        this.left = expression2;
        this.right = expression3;
    }

    @Override
    public Boolean isTrue(Map<String, Object> map) throws SQLException {
        Comparable comparable = (Comparable)this.left.eval(map);
        Comparable comparable2 = (Comparable)this.right.eval(map);
        Comparable comparable3 = (Comparable)this.obj.eval(map);
        Integer n = RelopExpression.compare(comparable, comparable3, map);
        if (n == null) {
            return null;
        }
        if (n <= 0) {
            Integer n2 = RelopExpression.compare(comparable2, comparable3, map);
            if (n2 == null) {
                return null;
            }
            if (n2 >= 0) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return "B " + this.obj + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.obj.usedColumns(set));
        linkedList.addAll(this.left.usedColumns(set));
        linkedList.addAll(this.right.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.obj.aggregateFunctions());
        linkedList.addAll(this.left.aggregateFunctions());
        linkedList.addAll(this.right.aggregateFunctions());
        return linkedList;
    }
}

