/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;

class AndExpression
extends LogicalExpression {
    LogicalExpression left;
    LogicalExpression right;
    boolean isValid;

    public AndExpression(Expression expression, Expression expression2) {
        boolean bl = this.isValid = expression instanceof LogicalExpression && expression2 instanceof LogicalExpression;
        if (this.isValid) {
            this.left = (LogicalExpression)expression;
            this.right = (LogicalExpression)expression2;
            this.isValid = expression.isValid() && expression2.isValid();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public Boolean isTrue(Map<String, Object> map) throws SQLException {
        Boolean bl = this.left.isTrue(map);
        if (bl == null) {
            return null;
        }
        if (bl.booleanValue()) {
            Boolean bl2 = this.right.isTrue(map);
            if (bl2 == null) {
                return null;
            }
            if (bl2.booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return "AND " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.left.usedColumns(set));
        linkedList.addAll(this.right.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.left.aggregateFunctions());
        linkedList.addAll(this.right.aggregateFunctions());
        return linkedList;
    }
}

