/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.model;

import com.dbeaver.ee.qmdb.QMDBDataSourceProvider;
import com.dbeaver.ee.qmdb.internal.QMDBActivator;
import com.dbeaver.ee.qmdb.model.QMDBEventListener;
import com.dbeaver.ee.qmdb.model.QMDBQueryFilter;
import com.dbeaver.ee.qmdb.model.QMDBQueryRecord;
import com.dbeaver.ee.qmdb.model.QMDBUtils;
import com.dbeaver.ee.qmdb.server.EmbeddedDatabase;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class QMDBModel {
    private static final Log log = Log.getLog(QMDBModel.class);
    private static QMDBModel instance;
    private QMDBEventListener qmHandler;
    private String schemaName;
    private String localHostName;
    private Long deployId;
    private Long versionId;
    private Long workspaceId;
    private Long runId;
    private EmbeddedDatabase embeddedDatabase;
    @Nullable
    private Connection dbConnection;

    public static synchronized QMDBModel getInstance() {
        if (instance == null) {
            instance = new QMDBModel();
        }
        return instance;
    }

    public static void shutdown() {
        if (instance != null) {
            instance.shutdownModel();
            instance = null;
        }
    }

    public QMDBModel() {
        log.debug((Object)"Opening QMDB connection...");
        this.openConnection();
        try {
            this.initializeSchema();
            this.qmHandler = new QMDBEventListener(this);
            QMUtils.registerMetaListener((QMMetaListener)this.qmHandler);
            log.debug((Object)"QMDB started");
        }
        catch (Exception e) {
            log.error((Object)"Error initializing QM database schema", (Throwable)e);
            this.closeConnection();
        }
    }

    public boolean isInitialized() {
        return this.dbConnection != null;
    }

    public EmbeddedDatabase getEmbeddedDatabase() {
        return this.embeddedDatabase;
    }

    private void openConnection() {
        if (this.dbConnection == null) {
            this.embeddedDatabase = new EmbeddedDatabase("qmdb");
            try {
                this.embeddedDatabase.start();
                this.dbConnection = this.embeddedDatabase.getConnection();
            }
            catch (DBException e) {
                log.error((Object)"Can't start QM embedded database", (Throwable)e);
            }
            if (this.dbConnection != null) {
                try {
                    this.dbConnection.setAutoCommit(true);
                }
                catch (SQLException e) {
                    log.error((Object)"Error setting auto-commit state", (Throwable)e);
                }
            }
        }
    }

    private void shutdownModel() {
        log.debug((Object)"Closing QMDB connection.");
        if (this.qmHandler != null) {
            this.qmHandler.dispose();
            QMUtils.unregisterMetaListener((QMMetaListener)this.qmHandler);
        }
        try {
            this.endCurrentRun();
        }
        catch (SQLException e) {
            log.warn((Object)e);
        }
        this.closeConnection();
        log.debug((Object)"QMDB stopped.");
    }

    private void closeConnection() {
        if (this.embeddedDatabase != null) {
            try {
                this.embeddedDatabase.stop();
            }
            catch (DBException e) {
                log.warn((Object)"Error while stopping QM embedded database", (Throwable)e);
            }
            this.embeddedDatabase = null;
        } else if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException e) {
                log.warn((Object)"Error while closing QM Database connection", (Throwable)e);
            }
        }
        this.dbConnection = null;
    }

    private void initializeSchema() throws DBException, SQLException, IOException {
        this.schemaName = QMDBActivator.getDefault().getPreferences().getString("qmdb.database.schema");
        if (CommonUtils.isEmptyTrimmed((String)this.schemaName)) {
            this.schemaName = null;
        }
        if (this.embeddedDatabase != null) {
            this.schemaName = null;
        }
        this.localHostName = InetAddress.getLocalHost().getHostName();
        if (this.dbConnection == null) {
            log.error((Object)"No QMDB connection");
            return;
        }
        ResultSet tablesRS = this.dbConnection.getMetaData().getTables(null, this.schemaName, "QM_INFO", null);
        if (!tablesRS.next()) {
            this.createSchema();
        }
        this.checkSchemaVersion();
        log.debug((Object)"Check QMDB deployment");
        this.checkDBeaverDeployment();
        this.checkDBeaverVersion();
        this.checkDBeaverWorkspace();
        this.createDBeaverRun();
    }

    Long getRunId() {
        return this.runId;
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    public QMDBEventListener getQmHandler() {
        return this.qmHandler;
    }

    public String getTableName(String name) {
        if (this.schemaName == null) {
            return name;
        }
        return String.valueOf(this.schemaName) + "." + name;
    }

    private void createSchema() throws IOException, SQLException {
        log.debug((Object)"Create new QMDB database");
        InputStream ddlStream = QMDBDataSourceProvider.class.getClassLoader().getResourceAsStream("ddl/qm_schema.sql");
        if (ddlStream == null) {
            throw new IOException("Can't find schema DDL file ddl/qm_schema.sql");
        }
        try {
            this.executeScript(ddlStream);
        }
        finally {
            ContentUtils.close((Closeable)ddlStream);
        }
    }

    private void dropSchema() throws IOException, SQLException {
        log.debug((Object)"Drop previous QMDB database");
        JDBCUtils.executeSQL((Connection)this.dbConnection, (String)"DROP ALL OBJECTS", (Object[])new Object[0]);
    }

    private void executeScript(InputStream ddlStream) throws IOException, SQLException {
        String[] ddl;
        ByteArrayOutputStream ddlBuffer = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)ddlStream, (OutputStream)ddlBuffer);
        String[] stringArray = ddl = ddlBuffer.toString().split(";");
        int n = ddl.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(line = line.trim()).isEmpty()) {
                Throwable throwable = null;
                Object var9_10 = null;
                try (PreparedStatement dbStat = this.dbConnection.prepareStatement(line);){
                    dbStat.execute();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    private void checkSchemaVersion() throws SQLException, DBException, IOException {
        Number version = (Number)JDBCUtils.executeQuery((Connection)this.dbConnection, (String)("SELECT VERSION FROM " + this.getTableName("QM_INFO")), (Object[])new Object[0]);
        if (version == null) {
            JDBCUtils.executeSQL((Connection)this.dbConnection, (String)("INSERT INTO " + this.getTableName("QM_INFO") + " (VERSION,UPDATE_TIME) VALUES(?,?)"), (Object[])new Object[]{9, new Date()});
        } else if (version.intValue() <= 3) {
            this.dropSchema();
            this.createSchema();
            this.checkSchemaVersion();
        } else if (version.intValue() < 9) {
            int curVer = version.intValue();
            while (curVer < 9) {
                block12: {
                    int updateToVer = curVer + 1;
                    InputStream ddlStream = QMDBActivator.getDefault().getResourceStream("ddl/qm_schema_update_" + updateToVer + ".sql");
                    if (ddlStream != null) {
                        try {
                            try {
                                this.executeScript(ddlStream);
                            }
                            catch (Exception e) {
                                log.warn((Object)("Error updating QMDB schema from " + curVer + " to " + updateToVer), (Throwable)e);
                                ContentUtils.close((Closeable)ddlStream);
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            ContentUtils.close((Closeable)ddlStream);
                            throw throwable;
                        }
                        ContentUtils.close((Closeable)ddlStream);
                    }
                }
                ++curVer;
            }
            JDBCUtils.executeSQL((Connection)this.dbConnection, (String)("UPDATE " + this.getTableName("QM_INFO") + " SET VERSION=?,UPDATE_TIME=?"), (Object[])new Object[]{9, new Date()});
        }
    }

    private void checkDBeaverDeployment() throws SQLException {
        String installPath = Platform.getInstallLocation().getURL().toString();
        this.deployId = QMDBUtils.queryLong(this.dbConnection, "SELECT DEPLOY_ID FROM " + this.getTableName("QM_DBEAVER_DEPLOYMENT") + " WHERE INSTALL_PATH=?", installPath);
        if (this.deployId == null) {
            this.deployId = QMDBUtils.executeInsertAutoIncrement(this.dbConnection, "INSERT INTO " + this.getTableName("QM_DBEAVER_DEPLOYMENT") + " (INSTALL_PATH,HOST_NAME,UPDATE_TIME) VALUES(?,?,?)", installPath, this.localHostName, new Date());
        }
    }

    private void checkDBeaverVersion() throws SQLException {
        String versionName = GeneralUtils.getProductVersion().toString();
        this.versionId = QMDBUtils.queryLong(this.dbConnection, "SELECT VERSION_ID FROM " + this.getTableName("QM_DBEAVER_VERSION") + " WHERE VERSION_NAME=?", versionName);
        if (this.versionId == null) {
            this.versionId = QMDBUtils.executeInsertAutoIncrement(this.dbConnection, "INSERT INTO " + this.getTableName("QM_DBEAVER_VERSION") + " (VERSION_NAME,UPDATE_DEPLOY_ID,UPDATE_TIME) VALUES(?,?,?)", versionName, this.deployId, new Date());
        }
    }

    private void checkDBeaverWorkspace() throws SQLException {
        String workspacePath = Platform.getInstanceLocation().getURL().toString();
        this.workspaceId = QMDBUtils.queryLong(this.dbConnection, "SELECT WORKSPACE_ID FROM " + this.getTableName("QM_DBEAVER_WORKSPACE") + " WHERE WORKSPACE_PATH=?", workspacePath);
        if (this.workspaceId == null) {
            this.workspaceId = QMDBUtils.executeInsertAutoIncrement(this.dbConnection, "INSERT INTO " + this.getTableName("QM_DBEAVER_WORKSPACE") + " (WORKSPACE_PATH,UPDATE_TIME) VALUES(?,?)", workspacePath, new Date());
        }
    }

    private void createDBeaverRun() throws SQLException {
        this.runId = QMDBUtils.executeInsertAutoIncrement(this.dbConnection, "INSERT INTO " + this.getTableName("QM_DBEAVER_RUN") + " (DEPLOY_ID,VERSION_ID,WORKSPACE_ID,HOST_NAME,START_TIME) VALUES(?,?,?,?,?)", this.deployId, this.versionId, this.workspaceId, this.localHostName, new Date());
    }

    private void endCurrentRun() throws SQLException {
        if (this.dbConnection == null) {
            return;
        }
        JDBCUtils.executeSQL((Connection)this.dbConnection, (String)("UPDATE " + this.getTableName("QM_DBEAVER_RUN") + " SET STOP_TIME=? WHERE RUN_ID=?"), (Object[])new Object[]{new Date(), this.runId});
    }

    public List<QMDBQueryRecord> searchQueryHistory(DBRProgressMonitor monitor, QMDBQueryFilter filter) throws DBException {
        if (this.dbConnection == null) {
            return new ArrayList<QMDBQueryRecord>();
        }
        ArrayList<QMDBQueryRecord> results = new ArrayList<QMDBQueryRecord>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT q.QUERY_ID,q.QUERY_TEXT,s.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,c.DATASOURCE_ID,c.INSTANCE_ID,c.CONTEXT_NAME\nFROM ").append(this.getTableName("QM_QUERY")).append(" q, ").append(this.getTableName("QM_STATEMENT")).append(" s, ").append(this.getTableName("QM_EVENT")).append(" e, ").append(this.getTableName("QM_CONNECTION")).append(" c ");
        sql.append("\nWHERE q.QUERY_ID=s.QUERY_ID AND e.EVENT_ID=s.STATEMENT_ID AND c.CONNECTION_ID=e.CONNECTION_ID");
        if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
            sql.append("\nAND q.QUERY_TEXT LIKE ?");
        }
        if (filter.getRowOffset() > 0 || filter.getMaxRows() > 0) {
            sql.append("\nLIMIT ").append(filter.getRowOffset()).append(", ").append(filter.getMaxRows());
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement dbStat = this.dbConnection.prepareStatement(sql.toString());){
                int paramIndex = 1;
                if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
                    dbStat.setString(paramIndex++, "%" + filter.getQueryText() + "%");
                }
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (ResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        QMDBQueryRecord record = new QMDBQueryRecord();
                        record.setQueryId(dbResult.getLong("QUERY_ID"));
                        record.setQueryText(dbResult.getString("QUERY_TEXT"));
                        record.setStatementPurpose(dbResult.getInt("STATEMENT_PURPOSE"));
                        record.setErrorCode(dbResult.getLong("ERROR_CODE"));
                        record.setErrorMessage(dbResult.getString("ERROR_MESSAGE"));
                        record.setExecuteTime(dbResult.getLong("EXECUTE_TIME"));
                        record.setFetchTime(dbResult.getLong("FETCH_TIME"));
                        results.add(record);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error reading query history", (Throwable)e);
        }
        return results;
    }
}

