/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.asn1;

import com.sybase.jdbc4.security.asn1.ASN1Object;
import com.sybase.jdbc4.security.asn1.ASN1OctetString;
import com.sybase.jdbc4.security.asn1.ASN1TaggedObject;
import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import com.sybase.jdbc4.security.asn1.DERString;
import com.sybase.jdbc4.security.util.Strings;
import java.io.IOException;

public class DERUTF8String
extends ASN1Object
implements DERString {
    String string;

    public static DERUTF8String getInstance(Object object) {
        if (object == null || object instanceof DERUTF8String) {
            return (DERUTF8String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUTF8String.getInstance(aSN1TaggedObject.getObject());
    }

    DERUTF8String(byte[] byArray) {
        this.string = Strings.fromUTF8ByteArray(byArray);
    }

    public DERUTF8String(String string) {
        this.string = string;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String dERUTF8String = (DERUTF8String)dERObject;
        return this.getString().equals(dERUTF8String.getString());
    }

    @Override
    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(12, Strings.toUTF8ByteArray(this.string));
    }
}

