/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.AbstractSelfLoopRouter;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;

public class PolylineSelfLoopRouter
extends AbstractSelfLoopRouter {
    private static final double DISTANCE = 10.0;
    private static final double CORNER_CUT = 2.5;
    private static final double HALF = 0.5;
    private static final double QUARTER = 0.25;

    @Override
    public void routeSideSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopPort source = slEdge.getSource();
        SelfLoopPort target = slEdge.getTarget();
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        List<KVector> sourceBendPoints = this.cutCornerBendPoints(sourceBendPoint, source, (double)source.getMaximumLevel() * 10.0, targetBendPoint.distance(sourceBendPoint));
        List<KVector> targetBendPoints = this.cutCornerBendPoints(targetBendPoint, target, sourceBendPoint.distance(targetBendPoint), (double)target.getMaximumLevel() * 10.0);
        Collections.reverse(targetBendPoints);
        KVectorChain bendPoints = lEdge.getBendPoints();
        bendPoints.addAll(sourceBendPoints);
        bendPoints.addAll(targetBendPoints);
    }

    @Override
    public void routeCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopPort source = slEdge.getSource();
        SelfLoopPort target = slEdge.getTarget();
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        KVector cornerBendPoint = PolylineSelfLoopRouter.computeSingleCornerBendPoint(sourceBendPoint, targetBendPoint, target.getPortSide());
        List<KVector> sourceBendPoints = this.cutCornerBendPoints(sourceBendPoint, source, (double)source.getMaximumLevel() * 10.0, targetBendPoint.distance(sourceBendPoint));
        List<KVector> cornerBendPoints = this.cutCornerBendPoints(cornerBendPoint, target.getPortSide(), source.getDirection(), targetBendPoint.distance(sourceBendPoint), targetBendPoint.distance(sourceBendPoint), source.getMaximumLevel());
        List<KVector> targetBendPoints = this.cutCornerBendPoints(targetBendPoint, target, sourceBendPoint.distance(targetBendPoint), (double)target.getMaximumLevel() * 10.0);
        Collections.reverse(targetBendPoints);
        KVectorChain bendPoints = lEdge.getBendPoints();
        bendPoints.addAll(sourceBendPoints);
        bendPoints.addAll(cornerBendPoints);
        bendPoints.addAll(targetBendPoints);
    }

    @Override
    public void routeOpposingSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopPort source = slEdge.getSource();
        SelfLoopPort target = slEdge.getTarget();
        SelfLoopNode slNode = (SelfLoopNode)lEdge.getSource().getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        SelfLoopRoutingDirection routingDirection = this.computeRoutingDirection(source, target);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        KVector firstCorner = cornerBendPoints.get(0);
        KVector secondCorner = cornerBendPoints.get(1);
        List<KVector> sourceBendPoints = this.cutCornerBendPoints(sourceBendPoint, source, (double)source.getMaximumLevel() * 10.0, sourceBendPoint.distance(firstCorner));
        PortSide nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? source.getPortSide().left() : source.getPortSide().right();
        List<KVector> firstCornerBendPoints = this.cutCornerBendPoints(firstCorner, nextSide, routingDirection, sourceBendPoint.distance(firstCorner), secondCorner.distance(firstCorner), source.getMaximumLevel());
        nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? nextSide.left() : nextSide.right();
        List<KVector> secondCornerBendPoints = this.cutCornerBendPoints(secondCorner, nextSide, routingDirection, secondCorner.distance(firstCorner), targetBendPoint.distance(secondCorner), target.getMaximumLevel());
        List<KVector> targetBendPoints = this.cutCornerBendPoints(targetBendPoint, target, targetBendPoint.distance(secondCorner), (double)target.getMaximumLevel() * 10.0);
        Collections.reverse(targetBendPoints);
        KVectorChain bendPoints = lEdge.getBendPoints();
        bendPoints.addAll(sourceBendPoints);
        bendPoints.addAll(firstCornerBendPoints);
        bendPoints.addAll(secondCornerBendPoints);
        bendPoints.addAll(targetBendPoints);
    }

    @Override
    public void routeThreeCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge loop = slEdge.getEdge();
        SelfLoopPort source = slEdge.getSource();
        SelfLoopPort target = slEdge.getTarget();
        SelfLoopNode slNode = (SelfLoopNode)loop.getSource().getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        SelfLoopRoutingDirection routingDirection = this.computeRoutingDirection(source, target);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        KVector firstCornerBendPoint = cornerBendPoints.get(0);
        KVector secondCornerBendPoint = cornerBendPoints.get(1);
        KVector thirdCornerBendPoint = cornerBendPoints.get(2);
        List<KVector> sourceBendPoints = this.cutCornerBendPoints(sourceBendPoint, source, (double)source.getMaximumLevel() * 10.0, sourceBendPoint.distance(firstCornerBendPoint));
        PortSide nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? source.getPortSide().left() : source.getPortSide().right();
        List<KVector> firstCornerBendPoints = this.cutCornerBendPoints(firstCornerBendPoint, nextSide, routingDirection, sourceBendPoint.distance(firstCornerBendPoint), secondCornerBendPoint.distance(firstCornerBendPoint), source.getMaximumLevel());
        nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? nextSide.left() : nextSide.right();
        List<KVector> secondCornerBendPoints = this.cutCornerBendPoints(secondCornerBendPoint, nextSide, routingDirection, secondCornerBendPoint.distance(firstCornerBendPoint), thirdCornerBendPoint.distance(secondCornerBendPoint), target.getMaximumLevel());
        nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? nextSide.left() : nextSide.right();
        List<KVector> thirdCornerBendPoints = this.cutCornerBendPoints(thirdCornerBendPoint, nextSide, routingDirection, secondCornerBendPoint.distance(thirdCornerBendPoint), targetBendPoint.distance(thirdCornerBendPoint), target.getMaximumLevel());
        List<KVector> targetBendPoints = this.cutCornerBendPoints(targetBendPoint, target, targetBendPoint.distance(secondCornerBendPoint), (double)target.getMaximumLevel() * 10.0);
        Collections.reverse(targetBendPoints);
        KVectorChain bendPoints = loop.getBendPoints();
        bendPoints.addAll(sourceBendPoints);
        bendPoints.addAll(firstCornerBendPoints);
        bendPoints.addAll(secondCornerBendPoints);
        bendPoints.addAll(thirdCornerBendPoints);
        bendPoints.addAll(targetBendPoints);
    }

    @Override
    public void routeFourCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopPort source = slEdge.getSource();
        SelfLoopPort target = slEdge.getTarget();
        SelfLoopNode slNode = (SelfLoopNode)lEdge.getSource().getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        SelfLoopRoutingDirection routingDirection = this.computeRoutingDirection(source, target);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        KVector firstCornerBendPoint = cornerBendPoints.get(0);
        KVector secondCornerBendPoint = cornerBendPoints.get(1);
        KVector thirdCornerBendPoint = cornerBendPoints.get(2);
        KVector fourthCornerBendPoint = cornerBendPoints.get(slNode.getSides().size() - 1);
        List<KVector> sourceBendPoints = this.cutCornerBendPoints(sourceBendPoint, source, (double)source.getMaximumLevel() * 10.0, sourceBendPoint.distance(firstCornerBendPoint));
        PortSide nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? source.getPortSide().left() : source.getPortSide().right();
        List<KVector> firstCornerBendPoints = this.cutCornerBendPoints(firstCornerBendPoint, nextSide, routingDirection, sourceBendPoint.distance(firstCornerBendPoint), secondCornerBendPoint.distance(firstCornerBendPoint), source.getMaximumLevel());
        nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? nextSide.left() : nextSide.right();
        List<KVector> secondCornerBendPoints = this.cutCornerBendPoints(secondCornerBendPoint, nextSide, routingDirection, secondCornerBendPoint.distance(firstCornerBendPoint), thirdCornerBendPoint.distance(secondCornerBendPoint), target.getMaximumLevel());
        nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? nextSide.left() : nextSide.right();
        List<KVector> thirdCornerBendPoints = this.cutCornerBendPoints(thirdCornerBendPoint, nextSide, routingDirection, secondCornerBendPoint.distance(thirdCornerBendPoint), fourthCornerBendPoint.distance(thirdCornerBendPoint), target.getMaximumLevel());
        nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? nextSide.left() : nextSide.right();
        List<KVector> fourthCornerBendPoints = this.cutCornerBendPoints(fourthCornerBendPoint, nextSide, routingDirection, fourthCornerBendPoint.distance(thirdCornerBendPoint), targetBendPoint.distance(fourthCornerBendPoint), target.getMaximumLevel());
        List<KVector> targetBendPoints = this.cutCornerBendPoints(targetBendPoint, target, targetBendPoint.distance(secondCornerBendPoint), (double)target.getMaximumLevel() * 10.0);
        Collections.reverse(targetBendPoints);
        KVectorChain bendPoints = lEdge.getBendPoints();
        bendPoints.addAll(sourceBendPoints);
        bendPoints.addAll(firstCornerBendPoints);
        bendPoints.addAll(secondCornerBendPoints);
        bendPoints.addAll(thirdCornerBendPoints);
        bendPoints.addAll(fourthCornerBendPoints);
        bendPoints.addAll(targetBendPoints);
    }

    private List<KVector> cutCornerBendPoints(KVector bendPoint, SelfLoopPort slPort, double distanceToPreviousPoint, double distanceToNextPoint) {
        return this.cutCornerBendPoints(bendPoint, slPort.getPortSide(), slPort.getDirection(), distanceToPreviousPoint, distanceToNextPoint, slPort.getMaximumLevel());
    }

    private List<KVector> cutCornerBendPoints(KVector bendPoint, PortSide side, SelfLoopRoutingDirection routingDirection, double distanceToPreviousPoint, double distanceToNextPoint, int level) {
        ArrayList<KVector> result = new ArrayList<KVector>();
        double shortestDistance = Math.min(distanceToPreviousPoint, distanceToNextPoint);
        double distanceValue = 2.5 * (double)level > 0.5 * shortestDistance ? 0.25 * shortestDistance : 2.5 * (double)level;
        double direction = SplinesMath.portSideToDirection(side);
        KVector directionVector = new KVector(direction).scale(-1.0);
        KVector firstCutBendpoint = bendPoint.clone().add(directionVector.scale(distanceValue));
        result.add(firstCutBendpoint);
        PortSide nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? side.left() : side.right();
        direction = SplinesMath.portSideToDirection(nextSide);
        directionVector = new KVector(direction);
        KVector secondCutBendpoint = bendPoint.clone().add(directionVector.scale(distanceValue));
        result.add(secondCutBendpoint);
        return result;
    }

    private SelfLoopRoutingDirection computeRoutingDirection(SelfLoopPort source, SelfLoopPort target) {
        SelfLoopRoutingDirection result = source.getDirection();
        if (result == SelfLoopRoutingDirection.BOTH) {
            result = target.getDirection() == SelfLoopRoutingDirection.LEFT ? SelfLoopRoutingDirection.RIGHT : SelfLoopRoutingDirection.LEFT;
        }
        return result;
    }
}

