/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.SelfLoopDistributionStrategy;
import org.eclipse.elk.alg.layered.options.SelfLoopOrderingStrategy;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.calculators.SelfLoopComponentDependencyGraphCalculator;
import org.eclipse.elk.alg.layered.p5edges.loops.calculators.SelfLoopLevelCalculator;
import org.eclipse.elk.alg.layered.p5edges.loops.position.FixedOrderSelfLoopPortPositioner;
import org.eclipse.elk.alg.layered.p5edges.loops.position.FixedSideSelfLoopPortPositioner;
import org.eclipse.elk.alg.layered.p5edges.loops.position.FreePortsSelfLoopPortPositioner;
import org.eclipse.elk.alg.layered.p5edges.loops.position.ISelfLoopPortPositioner;
import org.eclipse.elk.alg.layered.p5edges.loops.position.SelfLoopNodePortRestorator;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SelfLoopPlacer
implements ILayoutProcessor<LGraph> {
    private SelfLoopDistributionStrategy distribution;
    private SelfLoopOrderingStrategy ordering;

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Self-Loop positioning", 1.0f);
        this.distribution = (SelfLoopDistributionStrategy)((Object)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_SELF_LOOP_DISTRIBUTION));
        this.ordering = (SelfLoopOrderingStrategy)((Object)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_SELF_LOOP_ORDERING));
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                if (node.getType() != LNode.NodeType.NORMAL) continue;
                SelfLoopNode slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
                List<SelfLoopComponent> components = slNode.getSelfLoopComponents();
                ISelfLoopPortPositioner positioner = this.getPositioner(node);
                positioner.position(node);
                SelfLoopComponentDependencyGraphCalculator.calculateComponentDependecies(slNode);
                SelfLoopComponentDependencyGraphCalculator.calculateEdgeDependecies(components);
                SelfLoopLevelCalculator.calculatePortLevels(slNode);
                SelfLoopLevelCalculator.calculateEdgeOrders(components);
                SelfLoopLevelCalculator.calculateOpposingSegmentLevel(slNode);
                if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isPosFixed()) {
                    SelfLoopNodePortRestorator.restoreAndPlacePorts(node);
                    continue;
                }
                SelfLoopNodePortRestorator.restorePorts(node);
            }
        }
        monitor.done();
    }

    private ISelfLoopPortPositioner getPositioner(LNode node) {
        PortConstraints constraint = (PortConstraints)node.getProperty(InternalProperties.ORIGINAL_PORT_CONSTRAINTS);
        switch (constraint) {
            case UNDEFINED: 
            case FREE: {
                return new FreePortsSelfLoopPortPositioner(this.distribution, this.ordering);
            }
            case FIXED_SIDE: {
                return new FixedSideSelfLoopPortPositioner(this.ordering);
            }
            case FIXED_ORDER: 
            case FIXED_RATIO: 
            case FIXED_POS: {
                return new FixedOrderSelfLoopPortPositioner();
            }
        }
        throw new AssertionError((Object)("Unknown port constraint: " + constraint));
    }
}

