/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.resultset.document;

import com.dbeaver.ee.runtime.internal.ui.resultset.ResultsetMessages;
import com.dbeaver.ee.runtime.ui.resultset.document.AbstractDocumentPresentation;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentRenderer;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

class DocumentFrame
implements IDocumentFrame {
    private static final int FRAME_MARGIN = 5;
    private static final int FRAME_BORDER = 5;
    private final AbstractDocumentPresentation presentation;
    private int frameNumber;
    @Nullable
    private DBDDocument document;
    private DBDContent content;
    private IDocumentRenderer renderer;
    private int topOffset = 0;
    private int headerHeight = 20;
    private Point size = new Point(0, 0);
    private ResultSetRow row;
    private Point selectionStart;
    private Point selectionEnd;
    private boolean selectionActive;
    private Composite editorFrame;
    private IEditorPart editor;
    private boolean editMode;
    private Composite buttonsPanel;

    DocumentFrame(AbstractDocumentPresentation presentation, int frameNumber) {
        this.presentation = presentation;
        this.frameNumber = frameNumber;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public ResultSetRow getRow() {
        return this.row;
    }

    @Override
    public boolean isSelected() {
        return this.presentation.getController().getCurrentRow() == this.row;
    }

    void setDocument(ResultSetRow row, DBDDocument document) {
        if (document != null && document == this.document) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.row = row;
        this.document = document;
        this.renderer = document != null ? this.presentation.createRenderer(this) : null;
    }

    public void dispose() {
        this.document = null;
    }

    public void setRow(DBDAttributeBinding docAttr, ResultSetRow row) {
        Object[] values = row.getValues();
        Object docValue = values[docAttr.getOrdinalPosition()];
        if (docValue instanceof DBDDocument) {
            this.setDocument(row, (DBDDocument)docValue);
        } else if (docValue instanceof DBDContent) {
            this.content = (DBDContent)docValue;
            DBDDocument document = this.presentation.createDocumentFromContent(this.content);
            this.setDocument(row, document);
        } else {
            this.setDocument(row, null);
        }
    }

    private void updateSizesOnStructChange() {
        GC gc = new GC((Drawable)this.presentation.getControl());
        try {
            this.updateSizes(gc, false);
        }
        finally {
            gc.dispose();
        }
        this.presentation.updateMeasures(false);
    }

    public void updateSizes(GC gc, boolean editMode) {
        this.headerHeight = UIUtils.getFontHeight((Font)this.presentation.getLargeFont()) + 20;
        this.size = this.renderer == null ? new Point(0, this.headerHeight) : this.renderer.computeSize(gc);
        this.size.x += 20;
        this.size.y += 20 + this.headerHeight;
        if (editMode) {
            Rectangle clientArea = this.presentation.getControl().getClientArea();
            this.size.y = clientArea.height;
        }
    }

    public Composite getEditorFrame() {
        return this.editorFrame;
    }

    public void updateEditorBounds() {
        if (this.editorFrame == null) {
            return;
        }
        Rectangle clientArea = this.presentation.getControl().getClientArea();
        Rectangle bounds = this.getBounds(clientArea);
        Point buttonsSize = this.buttonsPanel.computeSize(-1, -1);
        this.buttonsPanel.setBounds(bounds.x + bounds.width - buttonsSize.x - 5 - 2, bounds.y + 5 + 2, buttonsSize.x, buttonsSize.y);
        bounds.x += 9;
        bounds.y += 7 + this.headerHeight;
        bounds.height -= 14 + this.headerHeight;
        bounds.width -= 18;
        this.editorFrame.setBounds(bounds);
        if (this.editor != null) {
            this.editorFrame.layout(true, true);
            this.buttonsPanel.layout();
        }
    }

    @Override
    public IResultSetController getController() {
        return this.presentation.getController();
    }

    @Override
    public DBDDocument getDocument() {
        return this.document;
    }

    @Override
    public Composite getCanvas() {
        return this.presentation.getControl();
    }

    @Override
    public Point getSize() {
        return this.size;
    }

    @Override
    public int getTopOffset() {
        return this.topOffset;
    }

    public void setTopOffset(int topOffset) {
        this.topOffset = topOffset;
    }

    @Override
    public Point getSelectionStart() {
        return this.selectionStart;
    }

    @Override
    public Point getSelectionEnd() {
        return this.selectionEnd;
    }

    @Override
    public boolean isSelectionActive() {
        return this.selectionActive;
    }

    public boolean isInPosition(int posX, int posY) {
        return posY >= this.topOffset + 5 && posY <= this.topOffset + this.size.y - 5 && posX >= 5;
    }

    @NotNull
    public Rectangle getBounds(Rectangle clientArea) {
        int frameWidth = Math.max(this.size.x, clientArea.width);
        return new Rectangle(-this.presentation.getHorizontalOffset(), this.topOffset - this.presentation.getVerticalOffset(), Math.max(frameWidth, this.size.x), this.size.y);
    }

    public void paintFrame(GC gc, Canvas canvas, Rectangle bounds) {
        bounds.x += 5;
        bounds.y += 5;
        bounds.height -= 10;
        bounds.width -= 10;
        Color bg = this.presentation.getBackgroundNormal();
        if (this.row.getState() == 2) {
            bg = this.presentation.getBackgroundAdded();
        } else if (this.row.getState() == 3) {
            bg = this.presentation.getBackgroundDeleted();
        } else if (this.row.changes != null && this.row.changes.containsKey(this.presentation.getCurrentAttribute())) {
            bg = this.presentation.getBackgroundModified();
        }
        gc.setBackground(bg);
        gc.fillRectangle(bounds);
        gc.setForeground(this.presentation.getColorShadow());
        gc.drawRectangle(bounds);
        if (this.isSelected()) {
            gc.setForeground(this.presentation.getColorForeground());
            gc.drawRectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
        }
        if (this.editMode) {
            gc.setForeground(this.presentation.getEditBorderColor());
            gc.drawRectangle(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
        }
        bounds.x += 5;
        bounds.y += 5;
        bounds.height -= 10;
        if (bounds.y + this.headerHeight >= 0) {
            Date createTime;
            String documentId = this.getDocumentId();
            gc.setForeground(this.presentation.getColorForeground());
            gc.setFont(this.presentation.getLargeFont());
            String docId = "[" + (this.row.getVisualNumber() + 1) + "] " + documentId;
            Point docIdSize = gc.stringExtent(docId);
            gc.drawText(docId, bounds.x + 5, bounds.y);
            gc.setForeground(this.presentation.getColorShadow());
            gc.setFont(this.presentation.getSmallFont());
            if (this.document != null && (createTime = (Date)this.document.getDocumentProperty("createTime")) != null) {
                gc.drawText(createTime.toString(), bounds.x + 5 + docIdSize.x + 20, bounds.y);
            }
            gc.drawLine(bounds.x + 5, bounds.y + this.headerHeight - 5, bounds.width / 2 - 5, bounds.y + this.headerHeight - 5);
        }
        bounds.y += this.headerHeight;
        bounds.height -= this.headerHeight;
        gc.setForeground(this.presentation.getColorForeground());
        gc.setFont(canvas.getFont());
        if (this.renderer != null) {
            this.renderer.paintDocument(gc, canvas, bounds);
        }
        gc.setBackground(canvas.getBackground());
    }

    private String getDocumentId() {
        Object documentId;
        Object object = documentId = this.document == null ? null : this.document.getDocumentProperty("id");
        if (documentId == null) {
            return "Document";
        }
        return CommonUtils.toString((Object)documentId);
    }

    public String convertToString(boolean copyHeader, DBDDisplayFormat format) {
        if (this.renderer != null) {
            StringBuilder buf = new StringBuilder(128);
            if (copyHeader) {
                buf.append(this.getDocumentId()).append("\n");
            }
            this.renderer.getContents(buf, this, format);
            return buf.toString();
        }
        return null;
    }

    void onMouseMove(MouseEvent e) {
        if (this.selectionActive) {
            this.selectionEnd = this.createTextPosition(e);
            this.presentation.getControl().redraw();
        }
    }

    boolean handleDoubleClick(MouseEvent e) {
        if (this.renderer.handleMouseDown(e, this.createTextPosition(e))) {
            this.updateSizesOnStructChange();
            return true;
        }
        return false;
    }

    void onMouseDown(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        Point curPosition = this.createTextPosition(e);
        if (this.renderer.handleMouseDown(e, curPosition)) {
            this.updateSizesOnStructChange();
        } else {
            boolean shift = (e.stateMask & SWT.MOD2) != 0;
            this.selectionEnd = shift && this.selectionStart != null ? curPosition : (this.selectionStart = curPosition);
            this.selectionActive = true;
        }
        this.presentation.getControl().redraw();
    }

    void onMouseUp(MouseEvent e) {
        boolean shift;
        boolean bl = shift = (e.stateMask & SWT.MOD2) != 0;
        if (shift) {
            this.selectionEnd = this.createTextPosition(e);
        }
        this.selectionActive = false;
    }

    private Point createTextPosition(MouseEvent e) {
        if (this.renderer == null) {
            return new Point(e.x, e.y);
        }
        return new Point((e.x + this.presentation.getHorizontalOffset() - 5 - 5) / this.renderer.getCharWidth(), (e.y + (this.presentation.getVerticalOffset() - this.topOffset) - 5 - 5 - this.headerHeight) / this.renderer.getLineHeight());
    }

    public void showEditor() throws DBException {
        if (this.editor != null) {
            this.editor.setFocus();
            return;
        }
        if (this.document == null) {
            this.document = this.presentation.createNewDocument();
        }
        Canvas parent = this.presentation.getControl();
        this.buttonsPanel = new Composite((Composite)parent, 0x40000000);
        this.buttonsPanel.setLayout((Layout)new RowLayout());
        if (!this.presentation.getController().isReadOnly()) {
            Button saveButton = new Button(this.buttonsPanel, 8);
            saveButton.setText(ResultsetMessages.DocumentFrame_button_save_text);
            saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (DocumentFrame.this.saveEditorChanges()) {
                        DocumentFrame.this.presentation.closeEditor();
                    }
                }
            });
        }
        Button cancelButton = new Button(this.buttonsPanel, 8);
        cancelButton.setText(ResultsetMessages.DocumentFrame_button_cancel_text);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentFrame.this.presentation.closeEditor();
                DocumentFrame.this.presentation.getControl().redraw();
            }
        });
        this.editorFrame = new Composite((Composite)parent, 0);
        this.editorFrame.setLayout((Layout)new FillLayout());
        this.updateEditorBounds();
        this.editor = this.presentation.createEditor(this.editorFrame, this.document, this.presentation.getController().isReadOnly());
        this.presentation.getController().lockActionsByControl((Control)this.editorFrame);
        this.presentation.getController().updateEditControls();
        this.editMode = true;
    }

    private boolean saveEditorChanges() {
        this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
        if (this.document != null) {
            try {
                IEditorInput editorInput = this.editor.getEditorInput();
                IStorage inputStorage = (IStorage)editorInput.getAdapter(IStorage.class);
                if (inputStorage == null) {
                    throw new DBException(String.valueOf(ResultsetMessages.DocumentFrame_e_no_storage) + editorInput);
                }
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream contents = inputStorage.getContents();){
                    this.document.updateDocument((DBRProgressMonitor)new VoidProgressMonitor(), contents, StandardCharsets.UTF_8);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                DBDAttributeBinding docAttr = this.presentation.getCurrentAttribute();
                if (docAttr == null) {
                    throw new DBException(ResultsetMessages.DocumentFrame_e_no_document_attribute);
                }
                DBDDocument newValue = this.content == null ? this.document : this.content;
                this.presentation.getController().getModel().updateCellValue(docAttr, this.row, (Object)newValue, true);
                this.presentation.updateMeasures(true);
                return true;
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError(ResultsetMessages.DocumentFrame_e_saving_doc_title, ResultsetMessages.DocumentFrame_e_saving_doc_message, (Throwable)e);
                return false;
            }
        }
        DBWorkbench.getPlatformUI().showError(ResultsetMessages.DocumentFrame_e_null_doc_title, ResultsetMessages.DocumentFrame_e_null_doc_message);
        return false;
    }

    public void closeEditor() {
        if (this.editMode) {
            if (this.editor != null) {
                this.editor.dispose();
                this.editor = null;
            }
            if (this.editorFrame != null) {
                this.editorFrame.dispose();
                this.editorFrame = null;
            }
            if (this.buttonsPanel != null) {
                this.buttonsPanel.dispose();
                this.buttonsPanel = null;
            }
            this.presentation.getController().updateEditControls();
        }
        this.editMode = false;
        this.presentation.getControl().redraw();
    }

    public void selectAll() {
        this.selectionStart = new Point(0, 0);
        this.selectionEnd = new Point(this.size.x, this.size.y);
    }
}

