/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class CommonUtils {
    public static final char PARAGRAPH_CHAR = '\u00b6';
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static boolean isJavaIdentifier(@NotNull CharSequence str) {
        if (str.length() == 0 || !Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NotNull
    public static String escapeJavaString(@NotNull String str) {
        StringBuilder res = new StringBuilder(str.length() + 5);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    res.append("\\\"");
                    break;
                }
                case '\n': {
                    res.append("\\n");
                    break;
                }
                case '\r': {
                    res.append("\\r");
                    break;
                }
                case '\t': {
                    res.append("\\t");
                    break;
                }
                default: {
                    res.append(c);
                }
            }
            ++i;
        }
        return res.toString();
    }

    @Nullable
    public static String escapeIdentifier(@Nullable String str) {
        if (str == null) {
            return null;
        }
        StringBuilder res = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                res.append(c);
            } else if (res.length() == 0 || res.charAt(res.length() - 1) != '_') {
                res.append('_');
            }
            ++i;
        }
        return res.toString();
    }

    @Nullable
    public static String escapeFileName(@Nullable String str) {
        if (str == null) {
            return null;
        }
        StringBuilder res = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isISOControl(c) || c == '\\' || c == '/' || c == '<' || c == '>' || c == '|' || c == '\"' || c == ':' || c == '*' || c == '?') {
                res.append('_');
            } else {
                res.append(c);
            }
            ++i;
        }
        return res.toString();
    }

    public static String makeDirectoryName(@NotNull String str) {
        if (!str.endsWith("/")) {
            str = String.valueOf(str) + "/";
        }
        return str;
    }

    @NotNull
    public static String removeTrailingSlash(@NotNull String str) {
        while (str.endsWith("/") || str.endsWith("\\")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String capitalizeWord(String str) {
        if (CommonUtils.isEmpty(str) || Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        return String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    public static String toCamelCase(String str) {
        if (CommonUtils.isEmpty(str)) {
            return null;
        }
        StringBuilder ret = new StringBuilder(str.length());
        boolean isWordStart = true;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                if (isWordStart) {
                    ret.append(Character.toUpperCase(ch));
                    isWordStart = false;
                } else {
                    ret.append(Character.toLowerCase(ch));
                }
            } else {
                ret.append(ch);
                isWordStart = true;
            }
            ++i;
        }
        return ret.toString();
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean isEmpty(@Nullable CharSequence value) {
        return value == null || value.length() == 0;
    }

    public static boolean isEmpty(@Nullable String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNotEmpty(@Nullable String value) {
        return !CommonUtils.isEmpty(value);
    }

    public static boolean isEmpty(@Nullable Collection<?> value) {
        return value == null || value.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> value) {
        return value == null || value.isEmpty();
    }

    @NotNull
    public static <T> Collection<T> safeCollection(@Nullable Collection<T> theList) {
        if (theList == null) {
            theList = Collections.emptyList();
        }
        return theList;
    }

    @NotNull
    public static <T> List<T> safeList(@Nullable List<T> theList) {
        if (theList == null) {
            theList = Collections.emptyList();
        }
        return theList;
    }

    @NotNull
    public static <T> List<T> copyList(@Nullable Collection<T> theList) {
        if (theList == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(theList);
    }

    @NotNull
    public static String notEmpty(@Nullable String value) {
        return value == null ? "" : value;
    }

    @Nullable
    public static String nullIfEmpty(@Nullable String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    public static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    public static boolean getBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolean(@Nullable String value, boolean defaultValue) {
        return CommonUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public static boolean getBoolean(@Nullable Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return CommonUtils.getBoolean(value.toString(), defaultValue);
    }

    @NotNull
    public static String getLineSeparator() {
        String lineSeparator = System.getProperty("line.separator");
        return lineSeparator == null ? "\n" : lineSeparator;
    }

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable ex) {
        Throwable rootCause = ex;
        while (true) {
            if (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
                continue;
            }
            if (!(rootCause instanceof InvocationTargetException) || ((InvocationTargetException)rootCause).getTargetException() == null) break;
            rootCause = ((InvocationTargetException)rootCause).getTargetException();
        }
        return rootCause;
    }

    public static boolean equalObjects(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean equalOrEmptyStrings(@Nullable String s1, @Nullable String s2) {
        return CommonUtils.equalObjects(s1, s2) || CommonUtils.isEmpty(s1) && CommonUtils.isEmpty(s2);
    }

    @NotNull
    public static String toString(@Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static String toString(@Nullable Object object, String def) {
        if (object == null) {
            return def;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static boolean toBoolean(@Nullable Object object) {
        return object != null && CommonUtils.getBoolean(object.toString());
    }

    public static int toInt(@Nullable Object object, int def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(CommonUtils.toString(object));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static int toInt(@Nullable Object object) {
        return CommonUtils.toInt(object, 0);
    }

    public static boolean isInt(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Number) {
            return true;
        }
        try {
            Integer.parseInt(CommonUtils.toString(object));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static long toLong(@Nullable Object object) {
        return CommonUtils.toLong(object, 0L);
    }

    public static long toLong(@Nullable Object object, long defValue) {
        if (object == null) {
            return defValue;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(CommonUtils.toString(object));
        }
        catch (NumberFormatException numberFormatException) {
            return defValue;
        }
    }

    public static boolean isLong(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Number) {
            return true;
        }
        try {
            Long.parseLong(CommonUtils.toString(object));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static double toDouble(@Nullable Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(CommonUtils.toString(object));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static double toDouble(@Nullable Object object, double def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(CommonUtils.toString(object));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    @NotNull
    public static String toHexString(@Nullable byte[] bytes) {
        return bytes == null ? "" : CommonUtils.toHexString(bytes, 0, bytes.length);
    }

    @NotNull
    public static String toHexString(@Nullable byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] hexChars = new char[length * 2];
        int i = 0;
        while (i < length) {
            int v = bytes[offset + i] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
            ++i;
        }
        return new String(hexChars);
    }

    public static byte[] parseHexString(String hex) {
        int strLength = hex.length();
        byte[] data = new byte[strLength / 2];
        int i = 0;
        while (i < strLength) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static String toBinaryString(long longValue, int bitCount) {
        String strValue = Long.toString(longValue, 2);
        if (strValue.length() < bitCount) {
            char[] headZeroes = new char[bitCount - strValue.length()];
            Arrays.fill(headZeroes, '0');
            strValue = String.valueOf(String.valueOf(headZeroes)) + strValue;
        }
        return strValue;
    }

    public static String[] splitWithDelimiter(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        String delimiterReplacement = "DRDRDR";
        s = s.replace(delimiter, String.valueOf(delimiterReplacement) + delimiter);
        return s.split(delimiterReplacement);
    }

    @NotNull
    public static List<String> splitString(@Nullable String str, char delimiter) {
        if (CommonUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, String.valueOf(delimiter));
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    @NotNull
    public static String[] split(@Nullable String str, String delimiter) {
        if (CommonUtils.isEmpty(str)) {
            return new String[0];
        }
        return str.split(delimiter);
    }

    @NotNull
    public static String makeString(@Nullable List<String> tokens, char delimiter) {
        if (tokens == null) {
            return "";
        }
        if (tokens.size() == 1) {
            return tokens.get(0);
        }
        StringBuilder buf = new StringBuilder();
        for (String token : tokens) {
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(token);
        }
        return buf.toString();
    }

    @Nullable
    public static String truncateString(@Nullable String str, int maxLength) {
        if (str != null && str.length() > maxLength) {
            return str.substring(0, maxLength);
        }
        return str;
    }

    public static String joinStrings(String divider, String ... array) {
        if (array == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                str.append(divider);
            }
            str.append(array[i]);
            ++i;
        }
        return str.toString();
    }

    public static String joinStrings(String divider, Collection<String> col) {
        if (col == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (String item : col) {
            if (str.length() > 0) {
                str.append(divider);
            }
            str.append(item);
        }
        return str.toString();
    }

    public static boolean isEmptyTrimmed(@Nullable String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static boolean isBitSet(int value, int mask) {
        return (value & mask) == mask;
    }

    @Nullable
    public static <T extends Enum<T>> T valueOf(@NotNull Class<T> type, @Nullable String name) {
        return CommonUtils.valueOf(type, name, null, false);
    }

    @Nullable
    public static <T extends Enum<T>> T valueOf(@Nullable Class<T> type, @Nullable String name, T defValue, boolean underscoreSpaces) {
        if (name == null) {
            return defValue;
        }
        if ((name = name.trim()).length() == 0) {
            return defValue;
        }
        if (underscoreSpaces) {
            name = name.replace(' ', '_');
        }
        try {
            return Enum.valueOf(type, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String str, T defValue) {
        if (CommonUtils.isEmpty(str)) {
            return defValue;
        }
        try {
            return Enum.valueOf(enumType, str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    @NotNull
    public static <T> T getItem(@NotNull Collection<T> collection, int index) {
        if (collection instanceof List) {
            return (T)((List)collection).get(index);
        }
        Iterator<T> iter = collection.iterator();
        int i = 0;
        while (i < index) {
            iter.next();
            ++i;
        }
        return iter.next();
    }

    @NotNull
    public static <T extends Enum<T>> T fromOrdinal(Class<T> enumClass, int ordinal) {
        Enum[] enumConstants;
        Enum[] enumArray = enumConstants = (Enum[])enumClass.getEnumConstants();
        int n = enumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            Enum value = enumArray[n2];
            if (value.ordinal() == ordinal) {
                return (T)value;
            }
            ++n2;
        }
        IllegalArgumentException error = new IllegalArgumentException("Invalid ordinal " + ordinal + " for type " + enumClass.getName());
        if (enumConstants.length == 0) {
            throw error;
        }
        error.printStackTrace(System.err);
        return (T)enumConstants[0];
    }

    @NotNull
    public static <T> List<T> filterCollection(@NotNull Collection<?> collection, @NotNull Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object item : collection) {
            if (!type.isInstance(item)) continue;
            result.add(type.cast(item));
        }
        return result;
    }

    @NotNull
    public static String escapeDisplayString(@NotNull String delim) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < delim.length()) {
            char c = delim.charAt(i);
            if (c == '\n') {
                str.append("\\n");
            } else if (c == '\r') {
                str.append("\\r");
            } else if (c == '\t') {
                str.append("\\t");
            } else {
                str.append(c);
            }
            ++i;
        }
        return str.toString();
    }

    @NotNull
    public static String unescapeDisplayString(@NotNull String delim) {
        return delim.replace("\\t", "\t").replace("\\n", "\n").replace("\\r", "\r");
    }

    public static int hashCode(@Nullable Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static <T> T getOption(Map<String, ?> options, String name, T defValue) {
        Object optionValue = options.get(name);
        if (optionValue == null) {
            return defValue;
        }
        return (T)optionValue;
    }

    public static boolean getOption(Map<String, ?> options, String name) {
        return CommonUtils.getOption(options, name, false);
    }

    public static boolean getOption(Map<String, ?> options, String name, boolean defValue) {
        if (options == null) {
            return false;
        }
        Object optionValue = options.get(name);
        if (optionValue == null) {
            return defValue;
        }
        return Boolean.TRUE.equals(optionValue);
    }

    public static String fixedLengthString(String string, int length) {
        return String.format("%1$" + length + "s", string);
    }

    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String startPart) {
        if (CommonUtils.isEmpty(str) || CommonUtils.isEmpty(startPart)) {
            return false;
        }
        return str.regionMatches(true, 0, startPart, 0, startPart.length());
    }

    public static String niceFormatFloat(float val) {
        if (val == (float)((int)val)) {
            return String.valueOf((int)val);
        }
        return String.valueOf(val);
    }

    public static String niceFormatDouble(double val) {
        if (val == (double)((long)val)) {
            return String.valueOf((long)val);
        }
        return String.valueOf(val);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String compactWhiteSpaces(String str) {
        return str.replaceAll("\\s+", " ");
    }

    public static String getSingleLineString(String displayString) {
        return displayString.replace('\n', '\u00b6').replace("\r", "").replace("\t", " ").replace('\u0000', ' ');
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return CommonUtils.toString(o1).compareTo(CommonUtils.toString(o2));
    }

    public static int compareNumbers(Number value1, Number value2) {
        double numDiff = value1.doubleValue() - value2.doubleValue();
        return numDiff < 0.0 ? -1 : (numDiff > 0.0 ? 1 : 0);
    }

    public static String cutExtraLines(String message, int maxLines) {
        if (message == null || message.indexOf(10) == -1) {
            return message;
        }
        int lfCount = 0;
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (c == '\n') {
                ++lfCount;
            }
            buf.append(c);
            if (lfCount == maxLines) {
                buf.append("...");
                break;
            }
            ++i;
        }
        return buf.toString();
    }
}

