/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.imageview;

import java.io.InputStream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.imageview.ImageActionDelegate;
import org.jkiss.dbeaver.ui.controls.imageview.ImageViewCanvas;
import org.jkiss.dbeaver.ui.controls.imageview.ImageViewMessages;

public class ImageViewer
extends Composite {
    private ImageViewCanvas canvas;
    private IAction itemZoomIn;
    private IAction itemZoomOut;
    private IAction itemRotate;
    private IAction itemFit;
    private IAction itemOriginal;

    public ImageViewer(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.canvas = new ImageViewCanvas(this, 0);
        this.canvas.setLayoutData(new GridData(1808));
        Transfer[] types = new Transfer[]{ImageTransfer.getInstance()};
        int operations = 1;
        DragSource source = new DragSource((Control)this.canvas, operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = ImageViewer.this.canvas.getImageData() != null ? ImageViewer.this.canvas.getImageData() : null;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    ImageViewCanvas getCanvas() {
        return this.canvas;
    }

    public boolean loadImage(InputStream inputStream) {
        this.canvas.loadImage(inputStream);
        return this.canvas.getError() == null;
    }

    public boolean clearImage() {
        this.canvas.loadImage(null);
        return true;
    }

    public SWTException getLastError() {
        return this.canvas.getError();
    }

    public String getImageDescription() {
        ImageData imageData = this.getCanvas().getImageData();
        return String.valueOf(ImageViewer.getImageType(imageData.type)) + " " + imageData.width + "x" + imageData.height + "x" + imageData.depth + "  ";
    }

    public static String getImageType(int type) {
        switch (type) {
            case 0: {
                return "BMP";
            }
            case 1: {
                return "BMP RLE";
            }
            case 2: {
                return "GIF";
            }
            case 3: {
                return "ICO";
            }
            case 4: {
                return "JPEG";
            }
            case 5: {
                return "PNG";
            }
            case 6: {
                return "TIFF";
            }
            case 7: {
                return "OS2 BMP";
            }
        }
        return "UNKNOWN";
    }

    public void updateActions() {
        boolean hasImage = this.getCanvas().getSourceImage() != null;
        this.itemZoomIn.setEnabled(hasImage);
        this.itemZoomOut.setEnabled(hasImage);
        this.itemRotate.setEnabled(hasImage);
        this.itemFit.setEnabled(hasImage);
        this.itemOriginal.setEnabled(hasImage);
    }

    public void fillToolBar(IContributionManager toolBar) {
        this.itemZoomIn = new ImageActionDelegate(this, "toolbar.zoomin", ImageViewMessages.controls_imageview_zoom_in, (DBPImage)UIIcon.ZOOM_IN);
        this.itemZoomOut = new ImageActionDelegate(this, "toolbar.zoomout", ImageViewMessages.controls_imageview_zoom_out, (DBPImage)UIIcon.ZOOM_OUT);
        this.itemRotate = new ImageActionDelegate(this, "toolbar.rotate", ImageViewMessages.controls_imageview_rotate, (DBPImage)UIIcon.ROTATE_LEFT);
        this.itemFit = new ImageActionDelegate(this, "toolbar.fit", ImageViewMessages.controls_imageview_fit_window, (DBPImage)UIIcon.FIT_WINDOW);
        this.itemOriginal = new ImageActionDelegate(this, "toolbar.original", ImageViewMessages.controls_imageview_original_size, (DBPImage)UIIcon.ORIGINAL_SIZE);
        if (toolBar.find("actions_add") != null) {
            toolBar.insertBefore("actions_add", this.itemZoomIn);
            toolBar.insertBefore("actions_add", this.itemZoomOut);
            toolBar.insertBefore("actions_add", this.itemRotate);
            toolBar.insertBefore("actions_add", this.itemFit);
            toolBar.insertBefore("actions_add", this.itemOriginal);
            toolBar.insertBefore("actions_add", (IContributionItem)new Separator());
        } else {
            toolBar.add(this.itemZoomIn);
            toolBar.add(this.itemZoomOut);
            toolBar.add(this.itemRotate);
            toolBar.add(this.itemFit);
            toolBar.add(this.itemOriginal);
            toolBar.add((IContributionItem)new Separator());
        }
    }
}

