/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.SystemJob;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextContentAdapter;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.controls.resultset.FilterSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

class ResultSetFilterPanel
extends Composite
implements IContentProposalProvider,
IAdaptable {
    private static final Log log = Log.getLog(ResultSetFilterPanel.class);
    private static final int MIN_FILTER_TEXT_WIDTH = 50;
    private static final int MIN_FILTER_TEXT_HEIGHT = 20;
    private static final int MAX_HISTORY_PANEL_HEIGHT = 200;
    private static final String DEFAULT_QUERY_TEXT = "SQL";
    private final ResultSetViewer viewer;
    private final ActiveObjectPanel activeObjectPanel;
    private final EditFilterPanel editFilterPanel;
    private final RefreshPanel refreshPanel;
    private final HistoryPanel historyPanel;
    private final TextViewer filtersTextViewer;
    private final StyledText filtersText;
    private final ContentProposalAdapter filtersProposalAdapter;
    private final ToolBar filterToolbar;
    private final ToolItem filtersApplyButton;
    private final ToolItem filtersClearButton;
    private final ToolItem filtersSaveButton;
    private final ToolItem historyBackButton;
    private final ToolItem historyForwardButton;
    private final Composite filterComposite;
    private final Color hoverBgColor;
    private final Color shadowColor;
    private final GC sizingGC;
    private final Font hintFont;
    private String activeDisplayName = "SQL";
    private String prevQuery = null;
    private final List<String> filtersHistory = new ArrayList<String>();
    private Menu historyMenu;
    private boolean filterExpanded = false;

    ResultSetFilterPanel(ResultSetViewer rsv, Composite parent) {
        super(parent, 0);
        this.viewer = rsv;
        CSSUtils.setCSSClass((Widget)this, (String)"coloredByConnectionType");
        this.sizingGC = new GC((Drawable)this);
        GridLayout gl = new GridLayout(4, false);
        gl.marginHeight = 3;
        gl.marginWidth = 3;
        this.setLayout((Layout)gl);
        this.hoverBgColor = this.getDisplay().getSystemColor(19);
        this.shadowColor = this.getDisplay().getSystemColor(18);
        this.hintFont = UIUtils.modifyFont((Font)this.getFont(), (int)2);
        this.filterComposite = new Composite((Composite)this, 2048);
        gl = new GridLayout(5, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.filterComposite.setLayout((Layout)gl);
        this.filterComposite.setLayoutData((Object)new GridData(768));
        CSSUtils.setCSSClass((Widget)this.filterComposite, (String)"coloredByConnectionType");
        this.activeObjectPanel = new ActiveObjectPanel(this.filterComposite);
        this.filtersTextViewer = new TextViewer(this.filterComposite, 2);
        this.filtersTextViewer.setDocument((IDocument)new Document());
        this.filtersTextViewer.getTextWidget().setForeground(UIStyles.getDefaultTextForeground());
        TextViewerUndoManager undoManager = new TextViewerUndoManager(200);
        undoManager.connect((ITextViewer)this.filtersTextViewer);
        this.filtersTextViewer.setUndoManager((IUndoManager)undoManager);
        this.filtersText = this.filtersTextViewer.getTextWidget();
        GridData gd = new GridData(1808);
        gd.verticalIndent = 1;
        this.filtersText.setLayoutData((Object)gd);
        StyledTextUtils.fillDefaultStyledTextContextMenu((StyledText)this.filtersText);
        StyledTextUtils.enableDND((StyledText)this.filtersText);
        this.editFilterPanel = new EditFilterPanel(this.filterComposite);
        this.historyPanel = new HistoryPanel(this.filterComposite);
        this.refreshPanel = new RefreshPanel(this.filterComposite);
        UIUtils.addDefaultEditActionsSupport((IServiceLocator)this.viewer.getSite(), (Control)this.filtersText);
        this.filtersText.addPaintListener(e -> {
            boolean supportsDataFilter = this.viewer.supportsDataFilter();
            if (!supportsDataFilter || this.filtersText.isEnabled() && this.filtersText.getCharCount() == 0 && !this.filtersText.isFocusControl()) {
                e.gc.setForeground(this.shadowColor);
                e.gc.setFont(this.hintFont);
                e.gc.drawText(supportsDataFilter ? ResultSetMessages.sql_editor_resultset_filter_panel_text_enter_sql_to_filter : ResultSetMessages.sql_editor_resultset_filter_panel_text_enter_filter_not_support, 2, 0, true);
                e.gc.setFont(null);
            }
        });
        this.filtersText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ResultSetFilterPanel.this.filtersText.redraw();
            }

            public void focusLost(FocusEvent e) {
                ResultSetFilterPanel.this.filtersText.redraw();
            }
        });
        this.filtersText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = ResultSetFilterPanel.this.filtersText.getText();
                ResultSetFilterPanel.this.filtersApplyButton.setEnabled(true);
                ResultSetFilterPanel.this.filtersClearButton.setEnabled(!CommonUtils.isEmpty((String)filterText));
            }
        });
        this.filtersText.addTraverseListener(e -> {
            if (e.detail == 4) {
                if (this.filterExpanded) {
                    e.doit = true;
                    return;
                }
                e.doit = false;
                e.detail = 0;
            }
        });
        this.filtersText.addVerifyKeyListener(e -> {
            if (e.keyCode == 13 || e.keyCode == 10 || e.character == '\r') {
                if (this.filterExpanded && (e.stateMask & 0x40000) == 0) {
                    return;
                }
                e.doit = false;
            }
        });
        this.filtersText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    if (ResultSetFilterPanel.this.filterExpanded && (e.stateMask & 0x40000) == 0) {
                        return;
                    }
                    ResultSetFilterPanel.this.historyPanel.showFilterHistoryPopup();
                } else if (e.keyCode == 13 || e.keyCode == 10 || e.character == '\r') {
                    if (ResultSetFilterPanel.this.filtersProposalAdapter != null && ResultSetFilterPanel.this.filtersProposalAdapter.isProposalPopupOpen()) {
                        return;
                    }
                    if (ResultSetFilterPanel.this.filterExpanded && (e.stateMask & 0x40000) == 0) {
                        return;
                    }
                    e.doit = false;
                    ResultSetFilterPanel.this.setCustomDataFilter();
                }
            }
        });
        StyledTextContentAdapter contentAdapter = new StyledTextContentAdapter(this.filtersText){

            public void setControlContents(Control control, String text, int cursorPosition) {
                Point selection = ResultSetFilterPanel.this.filtersText.getSelection();
                String curText = ResultSetFilterPanel.this.filtersText.getText();
                int insertPosition = selection.x;
                int i = selection.x - 1;
                while (i >= 0) {
                    if (!Character.isUnicodeIdentifierPart(curText.charAt(i))) break;
                    insertPosition = i--;
                }
                ResultSetFilterPanel.this.filtersText.setSelection(insertPosition, selection.y);
                this.insertControlContents(control, text, cursorPosition);
            }
        };
        this.filtersProposalAdapter = UIUtils.installContentProposal((Control)this.filtersText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this, (boolean)false, (boolean)false);
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.viewer.getSite(), (Control)this.filtersText);
        this.filterToolbar = new ToolBar((Composite)this, 131328);
        this.filterToolbar.setLayoutData((Object)new GridData(34));
        this.filtersApplyButton = new ToolItem(this.filterToolbar, 524296);
        CSSUtils.setCSSClass((Widget)this.filtersApplyButton, (String)"coloredByConnectionType");
        this.filtersApplyButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_APPLY));
        this.filtersApplyButton.setToolTipText(ResultSetMessages.sql_editor_resultset_filter_panel_btn_apply);
        this.filtersApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetFilterPanel.this.setCustomDataFilter();
            }
        });
        this.filtersApplyButton.setEnabled(false);
        this.filtersClearButton = new ToolItem(this.filterToolbar, 524296);
        this.filtersClearButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_RESET));
        this.filtersClearButton.setToolTipText(ResultSetMessages.sql_editor_resultset_filter_panel_btn_remove);
        this.filtersClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetFilterPanel.this.viewer.resetDataFilter(true);
            }
        });
        this.filtersClearButton.setEnabled(false);
        this.filtersSaveButton = new ToolItem(this.filterToolbar, 524296);
        this.filtersSaveButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_SAVE));
        this.filtersSaveButton.setToolTipText(ResultSetMessages.sql_editor_resultset_filter_panel_btn_save);
        this.filtersSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetFilterPanel.this.viewer.saveDataFilter();
            }
        });
        this.filtersSaveButton.setEnabled(false);
        ToolItem filtersCustomButton = new ToolItem(this.filterToolbar, 524296);
        filtersCustomButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_CONFIG));
        filtersCustomButton.setToolTipText(ResultSetMessages.sql_editor_resultset_filter_panel_btn_custom);
        filtersCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new FilterSettingsDialog(ResultSetFilterPanel.this.viewer).open();
            }
        });
        filtersCustomButton.setEnabled(true);
        UIUtils.createToolBarSeparator((ToolBar)this.filterToolbar, (int)512);
        rsv.getAutoRefresh().populateRefreshButton(this.filterToolbar);
        UIUtils.createToolBarSeparator((ToolBar)this.filterToolbar, (int)512);
        this.historyBackButton = new ToolItem(this.filterToolbar, 524292);
        this.historyBackButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.RS_BACK));
        this.historyBackButton.setEnabled(false);
        this.historyBackButton.addSelectionListener((SelectionListener)new HistoryMenuListener(this.historyBackButton, true));
        this.historyForwardButton = new ToolItem(this.filterToolbar, 524292);
        this.historyForwardButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.RS_FORWARD));
        this.historyForwardButton.setEnabled(false);
        this.historyForwardButton.addSelectionListener((SelectionListener)new HistoryMenuListener(this.historyForwardButton, false));
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ResultSetFilterPanel.this.redrawPanels();
            }

            public void controlResized(ControlEvent e) {
                ResultSetFilterPanel.this.redrawPanels();
            }
        });
        this.enablePanelControls(false);
        this.addDisposeListener(e -> {
            if (this.historyMenu != null) {
                this.historyMenu.dispose();
                this.historyMenu = null;
            }
            UIUtils.dispose((Resource)this.sizingGC);
            UIUtils.dispose((Resource)this.hintFont);
        });
    }

    void enableFilters(boolean enableFilters) {
        Pattern mlCommentsPattern;
        Matcher m;
        if (this.isDisposed()) {
            return;
        }
        this.enablePanelControls(enableFilters);
        if (enableFilters) {
            boolean supportsDataFilter = this.viewer.supportsDataFilter();
            int historyPosition = this.viewer.getHistoryPosition();
            List<ResultSetViewer.HistoryStateItem> stateHistory = this.viewer.getStateHistory();
            String filterText = this.filtersText.getText();
            this.filtersText.setEnabled(supportsDataFilter);
            this.filtersApplyButton.setEnabled(supportsDataFilter);
            this.filtersClearButton.setEnabled(this.viewer.getModel().getDataFilter().hasFilters() || !CommonUtils.isEmpty((String)filterText));
            this.filtersSaveButton.setEnabled(this.viewer.getDataContainer() instanceof DBSEntity);
            if (historyPosition > 0) {
                this.historyBackButton.setEnabled(true);
                this.historyBackButton.setToolTipText(String.valueOf(stateHistory.get(historyPosition - 1).describeState()) + " (" + ActionUtils.findCommandDescription((String)"org.eclipse.ui.navigate.backwardHistory", (IServiceLocator)this.viewer.getSite(), (boolean)true) + ")");
            } else {
                this.historyBackButton.setEnabled(false);
            }
            if (historyPosition < stateHistory.size() - 1) {
                this.historyForwardButton.setEnabled(true);
                this.historyForwardButton.setToolTipText(String.valueOf(stateHistory.get(historyPosition + 1).describeState()) + " (" + ActionUtils.findCommandDescription((String)"org.eclipse.ui.navigate.forwardHistory", (IServiceLocator)this.viewer.getSite(), (boolean)true) + ")");
            } else {
                this.historyForwardButton.setEnabled(false);
            }
        }
        this.filterComposite.setBackground(this.filtersText.getBackground());
        String displayName = this.getActiveSourceQuery();
        if (this.prevQuery == null || !this.prevQuery.equals(displayName)) {
            this.loadFiltersHistory(displayName);
            this.prevQuery = displayName;
        }
        if ((m = (mlCommentsPattern = Pattern.compile("/\\*.*\\*/", 32)).matcher(displayName)).find()) {
            displayName = m.replaceAll("");
        }
        displayName = displayName.replaceAll("--.+", "");
        displayName = CommonUtils.compactWhiteSpaces((String)displayName);
        this.activeDisplayName = CommonUtils.notEmpty((String)CommonUtils.truncateString((String)displayName, (int)200));
        if (CommonUtils.isEmpty((String)this.activeDisplayName)) {
            this.activeDisplayName = DEFAULT_QUERY_TEXT;
        }
        this.filterComposite.layout();
        this.redrawPanels();
    }

    private void enablePanelControls(boolean enable) {
        this.setRedraw(false);
        try {
            this.filterToolbar.setEnabled(enable);
            this.editFilterPanel.setEnabled(enable);
            this.refreshPanel.setEnabled(enable);
            this.historyPanel.setEnabled(enable);
            this.filtersText.setEditable(enable && this.viewer.supportsDataFilter());
        }
        finally {
            this.setRedraw(true);
        }
    }

    private boolean isFiltersAvailable() {
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        return dataContainer != null && (dataContainer.getSupportedFeatures() & 4) != 0;
    }

    private void redrawPanels() {
        if (this.activeObjectPanel != null && !this.activeObjectPanel.isDisposed()) {
            this.activeObjectPanel.redraw();
        }
        if (this.historyPanel != null && !this.historyPanel.isDisposed()) {
            this.historyPanel.redraw();
        }
        if (this.editFilterPanel != null && !this.editFilterPanel.isDisposed()) {
            this.editFilterPanel.redraw();
        }
        if (this.refreshPanel != null && !this.refreshPanel.isDisposed()) {
            this.refreshPanel.redraw();
        }
    }

    public String getFilterText() {
        return this.filtersText.getText();
    }

    @NotNull
    public String getActiveQueryText() {
        String queryText;
        DBCStatistics statistics = this.viewer.getModel().getStatistics();
        String string = queryText = statistics == null ? null : statistics.getQueryText();
        if (queryText == null || queryText.isEmpty()) {
            DBSDataContainer dataContainer = this.viewer.getDataContainer();
            if (dataContainer != null) {
                if (dataContainer instanceof SQLQueryContainer) {
                    return ((SQLQueryContainer)dataContainer).getQuery().getText();
                }
                return dataContainer.getName();
            }
            queryText = DEFAULT_QUERY_TEXT;
        }
        return queryText;
    }

    @Nullable
    private DBPImage getActiveObjectImage() {
        DBNDatabaseNode dcNode;
        DBPDataSource dataSource;
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        if (dataContainer instanceof DBSEntity && (dataSource = this.viewer.getDataContainer().getDataSource()) != null && (dcNode = dataSource.getContainer().getPlatform().getNavigatorModel().findNode((DBSObject)dataContainer)) != null) {
            return dcNode.getNodeIcon();
        }
        if (dataContainer instanceof DBPImageProvider) {
            return ((DBPImageProvider)dataContainer).getObjectImage();
        }
        if (dataContainer instanceof DBSEntity) {
            return DBIcon.TREE_TABLE;
        }
        return UIIcon.SQL_TEXT;
    }

    @NotNull
    private String getActiveSourceQuery() {
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        String displayName = dataContainer != null ? dataContainer.getName() : this.getActiveQueryText();
        return displayName;
    }

    private void loadFiltersHistory(String query) {
        this.filtersHistory.clear();
        try {
            Collection<String> history = this.viewer.getFilterManager().getQueryFilterHistory(query);
            this.filtersHistory.addAll(history);
        }
        catch (Throwable e) {
            log.debug((Object)"Error reading history", e);
        }
    }

    private void setCustomDataFilter() {
        DBCExecutionContext context = this.viewer.getExecutionContext();
        if (context == null) {
            return;
        }
        String condition = this.filtersText.getText();
        StringBuilder currentCondition = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)this.viewer.getModel().getDataFilter(), (DBPDataSource)context.getDataSource(), null, (StringBuilder)currentCondition, (boolean)true);
        if (currentCondition.toString().trim().equals(condition.trim())) {
            return;
        }
        DBDDataFilter newFilter = new DBDDataFilter(this.viewer.getModel().getDataFilter());
        for (DBDAttributeConstraint ac : newFilter.getConstraints()) {
            ac.setCriteria(null);
        }
        newFilter.setWhere(condition);
        this.viewer.setDataFilter(newFilter, true);
    }

    void addFiltersHistory(String whereCondition) {
        boolean oldFilter = this.filtersHistory.remove(whereCondition);
        this.filtersHistory.add(whereCondition);
        if (!oldFilter) {
            try {
                this.viewer.getFilterManager().saveQueryFilterValue(this.getActiveSourceQuery(), whereCondition);
            }
            catch (Throwable e) {
                log.debug((Object)"Error saving filter", e);
            }
        }
        this.setFilterValue(whereCondition);
    }

    Control getEditControl() {
        return this.filtersText;
    }

    void setFilterValue(String whereCondition) {
        if (whereCondition != null && !this.filtersText.getText().trim().equals(whereCondition.trim())) {
            this.filtersText.setText(whereCondition);
        }
    }

    @NotNull
    private Control createObjectPanel(Shell popup) throws PartInitException {
        Composite panel = new Composite((Composite)popup, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        panel.setLayout((Layout)gl);
        Label iconLabel = new Label(panel, 0);
        DBPImage activeObjectImage = this.getActiveObjectImage();
        if (activeObjectImage != null) {
            iconLabel.setImage(DBeaverIcons.getImage((DBPImage)activeObjectImage));
        }
        iconLabel.setToolTipText(ResultSetMessages.sql_editor_resultset_filter_panel_label);
        iconLabel.setLayoutData((Object)new GridData(2));
        iconLabel.setCursor(this.getDisplay().getSystemCursor(21));
        iconLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ResultSetFilterPanel.this.openEditorForActiveQuery();
            }
        });
        Composite editorPH = new Composite(panel, 0);
        editorPH.setLayoutData((Object)new GridData(1808));
        editorPH.setLayout((Layout)new FillLayout());
        try {
            Object sqlPanel;
            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
            if (serviceSQL != null && (sqlPanel = serviceSQL.createSQLPanel((Object)this.viewer.getSite(), (Object)editorPH, (DBPContextProvider)this.viewer, DEFAULT_QUERY_TEXT, false, this.getActiveQueryText())) instanceof TextViewer) {
                StyledText textWidget = ((TextViewer)sqlPanel).getTextWidget();
                panel.setBackground(textWidget.getBackground());
                return textWidget;
            }
            return null;
        }
        catch (DBException e) {
            throw new PartInitException("Error creating SQL panel", (Throwable)e);
        }
    }

    private void openEditorForActiveQuery() {
        DBSDataContainer dataContainer = this.viewer.getDataContainer();
        String editorName = dataContainer instanceof DBSEntity ? dataContainer.getName() : "Query";
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            serviceSQL.openSQLConsole(dataContainer == null || dataContainer.getDataSource() == null ? null : dataContainer.getDataSource().getContainer(), editorName, this.getActiveQueryText());
        }
    }

    public IContentProposal[] getProposals(String contents, int position) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        if (this.viewer.getDataContainer() != null) {
            syntaxManager.init(this.viewer.getDataContainer().getDataSource());
        }
        SQLWordPartDetector wordDetector = new SQLWordPartDetector((IDocument)new Document(contents), syntaxManager, position);
        String word = wordDetector.getFullWord().toLowerCase(Locale.ENGLISH);
        ArrayList proposals = new ArrayList();
        DBRRunnableWithProgress reader = monitor -> {
            DBDAttributeBinding[] attributes;
            DBDAttributeBinding[] dBDAttributeBindingArray = attributes = this.viewer.getModel().getAttributes();
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attribute = dBDAttributeBindingArray[n2];
                String name = DBUtils.getUnQuotedIdentifier((DBPDataSource)attribute.getDataSource(), (String)attribute.getName());
                if (CommonUtils.isEmpty((String)word) || name.toLowerCase(Locale.ENGLISH).startsWith(word)) {
                    String content = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)attribute)) + " ";
                    proposals.add(new ContentProposal(content, attribute.getName(), DBInfoUtils.makeObjectDescription((DBRProgressMonitor)monitor, (DBPNamedObject)attribute.getAttribute(), (boolean)false), content.length()));
                }
                ++n2;
            }
        };
        SystemJob searchJob = new SystemJob("Extract attribute proposals", reader);
        searchJob.schedule();
        UIUtils.waitJobCompletion((AbstractJob)searchJob);
        return proposals.toArray(new IContentProposal[0]);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IUndoManager.class) {
            return adapter.cast(this.filtersTextViewer.getUndoManager());
        }
        return null;
    }

    private void toggleFilterPanel() {
        this.filterExpanded = !this.filterExpanded;
        GridData gd = (GridData)this.filtersText.getLayoutData();
        gd.heightHint = this.filtersText.getLineHeight() * (this.filterExpanded ? 5 : 1);
        this.getParent().layout(true);
    }

    private class ActiveObjectPanel
    extends FilterPanel {
        static final int MIN_INFO_PANEL_WIDTH = 300;
        static final int MIN_INFO_PANEL_HEIGHT = 100;
        static final int MAX_INFO_PANEL_HEIGHT = 400;
        private Shell popup;

        ActiveObjectPanel(Composite addressBar) {
            super(addressBar, 0);
            this.setToolTipText(ResultSetMessages.sql_editor_resultset_filter_panel_btn_open_console);
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    ResultSetFilterPanel.this.openEditorForActiveQuery();
                }

                public void mouseDown(MouseEvent e) {
                    UIUtils.asyncExec(() -> ActiveObjectPanel.this.showObjectInfoPopup(e));
                }
            });
        }

        private void showObjectInfoPopup(MouseEvent e) {
            Control editControl;
            if (this.popup != null) {
                this.popup.dispose();
            }
            if ((e.stateMask & 0x40000) != 0) {
                ResultSetFilterPanel.this.openEditorForActiveQuery();
                return;
            }
            this.popup = new Shell(this.getShell(), 16400);
            this.popup.setLayout((Layout)new FillLayout());
            try {
                editControl = ResultSetFilterPanel.this.createObjectPanel(this.popup);
            }
            catch (PartInitException e1) {
                DBWorkbench.getPlatformUI().showError("Object info", "Error opening object info", (Throwable)e1);
                this.popup.dispose();
                return;
            }
            if (editControl != null) {
                Point controlRect = editControl.computeSize(-1, -1);
                Rectangle parentRect = this.getDisplay().map((Control)ResultSetFilterPanel.this.activeObjectPanel, null, this.getBounds());
                Rectangle displayRect = this.getMonitor().getClientArea();
                int width = Math.min(((ResultSetFilterPanel)ResultSetFilterPanel.this).filterComposite.getSize().x, Math.max(300, controlRect.x + 30));
                int height = Math.min(400, Math.max(100, controlRect.y + 30));
                int x = parentRect.x + e.x + 1;
                int y = parentRect.y + e.y + 1;
                if (y + height > displayRect.y + displayRect.height) {
                    y = parentRect.y - height;
                }
                this.popup.setBounds(x, y, width, height);
                this.popup.setVisible(true);
                editControl.setFocus();
                editControl.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        ActiveObjectPanel.this.popup.dispose();
                    }
                });
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int maxWidth = 0;
            Composite control = ResultSetFilterPanel.this.viewer.getControl().getParent();
            while (maxWidth == 0 && control != null) {
                maxWidth = control.getSize().x / 4;
                control = control.getParent();
            }
            Point textSize = ResultSetFilterPanel.this.sizingGC.textExtent(ResultSetFilterPanel.this.activeDisplayName);
            DBPImage activeObjectImage = ResultSetFilterPanel.this.getActiveObjectImage();
            if (activeObjectImage != null) {
                Image image = DBeaverIcons.getImage((DBPImage)activeObjectImage);
                textSize.x += image.getBounds().width + 4;
            }
            return new Point(Math.max(50, Math.min(textSize.x + 10, maxWidth)), Math.min(textSize.y + 6, 20));
        }

        @Override
        protected void paintPanel(PaintEvent e) {
            Point hintSize = this.computeSize(-1, -1);
            int panelHeight = hintSize.y;
            e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
            if (this.hover) {
                e.gc.setBackground(ResultSetFilterPanel.this.hoverBgColor);
                e.gc.fillRectangle(e.x, e.y, e.width - 3, panelHeight);
                e.gc.drawLine(e.x + e.width - 4, e.y, e.x + e.width - 4, e.y + e.height);
            } else {
                e.gc.drawLine(e.x + e.width - 4, e.y + 2, e.x + e.width - 4, e.y + e.height - 4);
            }
            e.gc.setForeground(e.gc.getDevice().getSystemColor(6));
            e.gc.setClipping(e.x, e.y, e.width - 8, e.height);
            int textOffset = 2;
            DBPImage activeObjectImage = ResultSetFilterPanel.this.getActiveObjectImage();
            if (activeObjectImage != null) {
                Image icon = DBeaverIcons.getImage((DBPImage)activeObjectImage);
                Rectangle iconBounds = icon.getBounds();
                e.gc.drawImage(icon, 2, (panelHeight - iconBounds.height) / 2);
                textOffset += iconBounds.width + 2;
            }
            int textHeight = e.gc.getFontMetrics().getHeight();
            e.gc.drawText(ResultSetFilterPanel.this.activeDisplayName, textOffset, (panelHeight - textHeight) / 2);
            e.gc.setClipping(null);
        }
    }

    private class EditFilterPanel
    extends FilterPanel {
        private final Image enabledImageExpand;
        private final Image disabledImageExpand;
        private final Image enabledImageCollapse;
        private final Image disabledImageCollapse;

        EditFilterPanel(Composite addressBar) {
            super(addressBar, 0);
            this.setToolTipText("Expand filter panel");
            this.enabledImageExpand = DBeaverIcons.getImage((DBPImage)UIIcon.FIT_WINDOW);
            this.disabledImageExpand = new Image(this.enabledImageExpand.getDevice(), this.enabledImageExpand, 2);
            this.enabledImageCollapse = DBeaverIcons.getImage((DBPImage)UIIcon.ORIGINAL_SIZE);
            this.disabledImageCollapse = new Image(this.enabledImageCollapse.getDevice(), this.enabledImageCollapse, 2);
            this.addDisposeListener(e -> {
                UIUtils.dispose((Resource)this.disabledImageExpand);
                UIUtils.dispose((Resource)this.disabledImageCollapse);
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    ResultSetFilterPanel.this.toggleFilterPanel();
                }
            });
            GridData gd = new GridData(1072);
            gd.heightHint = 20;
            gd.widthHint = this.enabledImageExpand.getBounds().width + 4;
            this.setLayoutData(gd);
        }

        @Override
        protected void paintPanel(PaintEvent e) {
            e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
            if (this.hover) {
                e.gc.drawImage(ResultSetFilterPanel.this.filterExpanded ? this.enabledImageCollapse : this.enabledImageExpand, e.x, e.y + 2);
            } else {
                e.gc.drawImage(ResultSetFilterPanel.this.filterExpanded ? this.disabledImageCollapse : this.disabledImageExpand, e.x, e.y + 2);
            }
        }
    }

    private class FilterPanel
    extends Canvas {
        protected boolean hover;

        FilterPanel(Composite parent, int style) {
            super(parent, style);
            this.hover = false;
            GridData gd = new GridData(1042);
            this.setLayoutData(gd);
            this.addPaintListener(this::paintPanel);
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    FilterPanel.this.hover = true;
                    FilterPanel.this.redraw();
                }

                public void mouseExit(MouseEvent e) {
                    FilterPanel.this.hover = false;
                    FilterPanel.this.redraw();
                }
            });
        }

        protected void paintPanel(PaintEvent e) {
        }
    }

    private class HistoryMenuListener
    extends SelectionAdapter {
        private final ToolItem dropdown;
        private final boolean back;

        HistoryMenuListener(ToolItem item, boolean back) {
            this.dropdown = item;
            this.back = back;
        }

        public void widgetSelected(SelectionEvent e) {
            int historyPosition = ResultSetFilterPanel.this.viewer.getHistoryPosition();
            List<ResultSetViewer.HistoryStateItem> stateHistory = ResultSetFilterPanel.this.viewer.getStateHistory();
            if (e.detail == 4) {
                ToolItem item = (ToolItem)e.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                if (ResultSetFilterPanel.this.historyMenu != null) {
                    ResultSetFilterPanel.this.historyMenu.dispose();
                }
                ResultSetFilterPanel.this.historyMenu = new Menu((Control)this.dropdown.getParent().getShell());
                int i = historyPosition + (this.back ? -1 : 1);
                while (i >= 0 && i < stateHistory.size()) {
                    MenuItem mi = new MenuItem(ResultSetFilterPanel.this.historyMenu, 0);
                    ResultSetViewer.HistoryStateItem state = stateHistory.get(i);
                    mi.setText(state.describeState());
                    final int statePosition = i;
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultSetFilterPanel.this.viewer.navigateHistory(statePosition);
                        }
                    });
                    i += this.back ? -1 : 1;
                }
                ResultSetFilterPanel.this.historyMenu.setLocation(pt.x, pt.y + rect.height);
                ResultSetFilterPanel.this.historyMenu.setVisible(true);
            } else {
                int newPosition = this.back ? historyPosition - 1 : historyPosition + 1;
                ResultSetFilterPanel.this.viewer.navigateHistory(newPosition);
            }
        }
    }

    private class HistoryPanel
    extends FilterPanel {
        private final Image dropImageE;
        private final Image dropImageD;
        private TableItem hoverItem;
        private Shell popup;

        HistoryPanel(Composite addressBar) {
            super(addressBar, 0);
            this.setToolTipText("Filters history");
            this.dropImageE = DBeaverIcons.getImage((DBPImage)UIIcon.DROP_DOWN);
            this.dropImageD = new Image(this.dropImageE.getDevice(), this.dropImageE, 2);
            GridData gd = new GridData(1072);
            gd.heightHint = 20;
            gd.widthHint = this.dropImageE.getBounds().width + 2;
            this.setLayoutData(gd);
            this.addDisposeListener(e -> UIUtils.dispose((Resource)this.dropImageD));
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    HistoryPanel.this.showFilterHistoryPopup();
                }
            });
        }

        @Override
        protected void paintPanel(PaintEvent e) {
            e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
            e.gc.drawLine(e.x + 2, e.y + 2, e.x + 2, e.y + e.height - 4);
            if (this.hover) {
                e.gc.drawImage(this.dropImageE, e.x + 4, e.y + 2);
            } else {
                e.gc.drawImage(this.dropImageD, e.x + 4, e.y + 2);
            }
        }

        private void showFilterHistoryPopup() {
            if (this.popup != null) {
                this.popup.dispose();
            }
            this.popup = new Shell(this.getShell(), 16408);
            this.popup.setLayout((Layout)new FillLayout());
            Table editControl = this.createFilterHistoryPanel(this.popup);
            Point parentRect = this.getDisplay().map((Control)ResultSetFilterPanel.this.filtersText, null, new Point(0, 0));
            Rectangle displayRect = this.getMonitor().getClientArea();
            Point filterTextSize = ResultSetFilterPanel.this.filtersText.getSize();
            int width = filterTextSize.x + ((ResultSetFilterPanel)ResultSetFilterPanel.this).historyPanel.getSize().x + ((ResultSetFilterPanel)ResultSetFilterPanel.this).editFilterPanel.getSize().x + ((ResultSetFilterPanel)ResultSetFilterPanel.this).refreshPanel.getSize().x;
            int height = Math.min(200, editControl.computeSize((int)-1, (int)-1).y);
            int x = parentRect.x;
            int y = parentRect.y + this.getSize().y;
            if (y + height > displayRect.y + displayRect.height) {
                y = parentRect.y - height;
            }
            this.popup.setBounds(x, y, width, height);
            int tableWidth = editControl.getSize().x - editControl.getBorderWidth() * 2;
            ScrollBar vsb = editControl.getVerticalBar();
            if (vsb != null) {
                tableWidth -= vsb.getSize().x;
            }
            editControl.getColumn(0).setWidth(tableWidth);
            this.popup.setVisible(true);
            editControl.setFocus();
            editControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    HistoryPanel.this.popup.dispose();
                }
            });
        }

        @NotNull
        private Table createFilterHistoryPanel(final Shell popup) {
            final Table historyTable = new Table((Composite)popup, 67588);
            new TableColumn(historyTable, 0);
            if (!ResultSetFilterPanel.this.filtersHistory.isEmpty()) {
                String curFilterValue = ResultSetFilterPanel.this.filtersText.getText();
                int i = ResultSetFilterPanel.this.filtersHistory.size();
                while (i > 0) {
                    String hi = (String)ResultSetFilterPanel.this.filtersHistory.get(i - 1);
                    if (!CommonUtils.equalObjects((Object)hi, (Object)curFilterValue)) {
                        new TableItem(historyTable, 0).setText(hi);
                    }
                    --i;
                }
                if (historyTable.getItemCount() > 0) {
                    historyTable.setSelection(0);
                }
            }
            historyTable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    HistoryPanel.this.hoverItem = null;
                }
            });
            historyTable.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int selectionIndex;
                    TableItem item = HistoryPanel.this.hoverItem;
                    if (item == null && (selectionIndex = historyTable.getSelectionIndex()) != -1) {
                        item = historyTable.getItem(selectionIndex);
                    }
                    if (item != null && !item.isDisposed()) {
                        switch (e.keyCode) {
                            case 127: {
                                String filterValue = item.getText();
                                try {
                                    ResultSetFilterPanel.this.viewer.getFilterManager().deleteQueryFilterValue(ResultSetFilterPanel.this.getActiveSourceQuery(), filterValue);
                                }
                                catch (DBException e1) {
                                    log.warn((Object)("Error deleting filter value [" + filterValue + "]"), (Throwable)e1);
                                }
                                ResultSetFilterPanel.this.filtersHistory.remove(filterValue);
                                item.dispose();
                                HistoryPanel.this.hoverItem = null;
                                break;
                            }
                            case 13: 
                            case 32: {
                                String newFilter = item.getText();
                                popup.dispose();
                                ResultSetFilterPanel.this.setFilterValue(newFilter);
                                ResultSetFilterPanel.this.setCustomDataFilter();
                                break;
                            }
                            case 0x1000001: {
                                if (historyTable.getSelectionIndex() > 0) break;
                                popup.dispose();
                            }
                        }
                    }
                }
            });
            historyTable.addMouseMoveListener(e -> {
                TableItem tableItem = this.hoverItem = historyTable.getItem(new Point(e.x, e.y));
            });
            historyTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (HistoryPanel.this.hoverItem != null) {
                        String newFilter = HistoryPanel.this.hoverItem.getText();
                        popup.dispose();
                        ResultSetFilterPanel.this.setFilterValue(newFilter);
                        ResultSetFilterPanel.this.setCustomDataFilter();
                    }
                }
            });
            return historyTable;
        }
    }

    private class RefreshPanel
    extends FilterPanel {
        private final Image enabledImage;
        private final Image disabledImage;

        RefreshPanel(Composite addressBar) {
            super(addressBar, 0);
            this.setToolTipText(ResultSetMessages.controls_resultset_viewer_action_refresh);
            this.enabledImage = DBeaverIcons.getImage((DBPImage)UIIcon.RS_REFRESH);
            this.disabledImage = new Image(this.enabledImage.getDevice(), this.enabledImage, 2);
            this.addDisposeListener(e -> UIUtils.dispose((Resource)this.disabledImage));
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!ResultSetFilterPanel.this.viewer.isRefreshInProgress() && e.x > 8) {
                        ResultSetFilterPanel.this.viewer.refreshData(null);
                        RefreshPanel.this.redraw();
                    }
                }
            });
            GridData gd = new GridData(1072);
            gd.heightHint = 20;
            gd.widthHint = 10 + this.enabledImage.getBounds().width + 6;
            this.setLayoutData(gd);
        }

        @Override
        protected void paintPanel(PaintEvent e) {
            e.gc.setForeground(ResultSetFilterPanel.this.shadowColor);
            e.gc.drawLine(e.x + 4, e.y + 2, e.x + 4, e.y + e.height - 4);
            if (ResultSetFilterPanel.this.viewer.isRefreshInProgress()) {
                e.gc.drawImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLOSE), e.x + 10, e.y + 2);
            } else if (this.hover) {
                e.gc.drawImage(this.enabledImage, e.x + 10, e.y + 2);
            } else {
                e.gc.drawImage(this.disabledImage, e.x + 10, e.y + 2);
            }
        }
    }
}

