/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.registry;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardDataType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardMapQueryDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardViewTypeDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DashboardRegistry {
    private static final Log log = Log.getLog(DashboardRegistry.class);
    private static DashboardRegistry instance = null;
    private final List<DashboardViewTypeDescriptor> viewTypeList = new ArrayList<DashboardViewTypeDescriptor>();
    private final Map<String, DashboardMapQueryDescriptor> mapQueries = new LinkedHashMap<String, DashboardMapQueryDescriptor>();
    private final Map<String, DashboardDescriptor> dashboardList = new LinkedHashMap<String, DashboardDescriptor>();

    public static synchronized DashboardRegistry getInstance() {
        if (instance == null) {
            instance = new DashboardRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DashboardRegistry(IExtensionRegistry registry) {
        IConfigurationElement ext;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dashboard");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("dashboardView".equals(ext.getName())) {
                this.viewTypeList.add(new DashboardViewTypeDescriptor(ext));
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            DashboardMapQueryDescriptor query;
            ext = iConfigurationElementArray[n2];
            if ("mapQuery".equals(ext.getName()) && !CommonUtils.isEmpty((String)(query = new DashboardMapQueryDescriptor(ext)).getId()) && !CommonUtils.isEmpty((String)query.getQueryText())) {
                this.mapQueries.put(query.getId(), query);
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("dashboard".equals(ext.getName())) {
                DashboardDescriptor dashboard = new DashboardDescriptor(this, ext);
                this.dashboardList.put(dashboard.getId(), dashboard);
            }
            ++n2;
        }
        File configFile = this.getDashboardsConfigFile();
        if (configFile.exists()) {
            try {
                this.loadConfigFromFile(configFile);
            }
            catch (Exception e) {
                log.error((Object)"Error loading dashboard configuration", (Throwable)e);
            }
        }
    }

    private void loadConfigFromFile(File configFile) throws XMLException {
        Document dbDocument = XMLUtils.parseDocument((File)configFile);
        for (Element dbElement : XMLUtils.getChildElementList((Element)dbDocument.getDocumentElement(), (String)"dashboard")) {
            DashboardDescriptor dashboard = new DashboardDescriptor(this, dbElement);
            this.dashboardList.put(dashboard.getId(), dashboard);
        }
    }

    private void saveConfigFile() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileOutputStream out = new FileOutputStream(this.getDashboardsConfigFile());){
                XMLBuilder xml = new XMLBuilder((OutputStream)out, "UTF-8");
                xml.setButify(true);
                xml.startElement("dashboards");
                for (DashboardDescriptor dashboard : this.dashboardList.values()) {
                    if (!dashboard.isCustom()) continue;
                    xml.startElement("dashboard");
                    dashboard.serialize(xml);
                    xml.endElement();
                }
                xml.endElement();
                xml.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving dashboard configuration", (Throwable)e);
        }
    }

    private File getDashboardsConfigFile() {
        return new File(UIDashboardActivator.getDefault().getStateLocation().toFile(), "dashboards.xml");
    }

    public DashboardViewTypeDescriptor getViewType(String id) {
        for (DashboardViewTypeDescriptor descriptor : this.viewTypeList) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public List<DashboardDescriptor> getAllDashboards() {
        return new ArrayList<DashboardDescriptor>(this.dashboardList.values());
    }

    public DashboardDescriptor getDashboard(String id) {
        return this.dashboardList.get(id);
    }

    public List<DashboardDescriptor> getDashboards(DBPNamedObject source, boolean defaultOnly) {
        String driverClass;
        String driverId;
        String providerId;
        if (source instanceof DBPDataSourceContainer) {
            source = ((DBPDataSourceContainer)source).getDriver();
        }
        if (source instanceof DBPDataSourceProviderDescriptor) {
            providerId = ((DBPDataSourceProviderDescriptor)source).getId();
            driverId = null;
            driverClass = null;
        } else {
            providerId = ((DBPDriver)source).getProviderId();
            driverId = ((DBPDriver)source).getId();
            driverClass = ((DBPDriver)source).getDriverClassName();
        }
        ArrayList<DashboardDescriptor> result = new ArrayList<DashboardDescriptor>();
        for (DashboardDescriptor dd : this.dashboardList.values()) {
            if (!dd.matches(providerId, driverId, driverClass) || defaultOnly && !dd.isShowByDefault()) continue;
            result.add(dd);
        }
        return result;
    }

    public void createDashboard(DashboardDescriptor dashboard) throws IllegalArgumentException {
        if (this.dashboardList.containsKey(dashboard.getId())) {
            throw new IllegalArgumentException("Dashboard " + dashboard.getId() + "' already exists");
        }
        if (!dashboard.isCustom()) {
            throw new IllegalArgumentException("Only custom dashboards can be added");
        }
        this.dashboardList.put(dashboard.getId(), dashboard);
        this.saveConfigFile();
    }

    public void removeDashboard(DashboardDescriptor dashboard) throws IllegalArgumentException {
        if (!this.dashboardList.containsKey(dashboard.getId())) {
            throw new IllegalArgumentException("Dashboard " + dashboard.getId() + "' doesn't exist");
        }
        if (!dashboard.isCustom()) {
            throw new IllegalArgumentException("Only custom dashboards can be removed");
        }
        this.dashboardList.remove(dashboard.getId());
        this.saveConfigFile();
    }

    public List<DashboardViewType> getAllViewTypes() {
        return new ArrayList<DashboardViewType>(this.viewTypeList);
    }

    public List<DashboardViewType> getSupportedViewTypes(DashboardDataType dataType) {
        ArrayList<DashboardViewType> result = new ArrayList<DashboardViewType>();
        for (DashboardViewType dashboardViewType : this.viewTypeList) {
            if (!ArrayUtils.contains((Object[])dashboardViewType.getSupportedTypes(), (Object)((Object)dataType))) continue;
            result.add(dashboardViewType);
        }
        return result;
    }

    public List<DBPNamedObject> getAllSupportedSources() {
        LinkedHashSet<DBPNamedObject> result = new LinkedHashSet<DBPNamedObject>();
        for (DashboardDescriptor dd : this.dashboardList.values()) {
            result.addAll(dd.getSupportedSources());
        }
        ArrayList<DBPNamedObject> sortedDrivers = new ArrayList<DBPNamedObject>(result);
        sortedDrivers.sort(Comparator.comparing(DBPNamedObject::getName));
        return sortedDrivers;
    }

    public void saveSettings() {
        this.saveConfigFile();
    }

    public DashboardMapQueryDescriptor getMapQuery(String id) {
        return this.mapQueries.get(id);
    }
}

