/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DashboardViewConfiguration {
    private static final Log log = Log.getLog(DashboardViewConfiguration.class);
    private String viewId;
    private final DBPDataSourceContainer dataSourceContainer;
    private List<DashboardItemViewConfiguration> items = new ArrayList<DashboardItemViewConfiguration>();
    private boolean openConnectionOnActivate;
    private boolean useSeparateConnection;

    public DashboardViewConfiguration(DBPDataSourceContainer dataSourceContainer, String viewId) {
        this.dataSourceContainer = dataSourceContainer;
        this.viewId = viewId;
        this.loadSettings();
    }

    public String getViewId() {
        return this.viewId;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public List<DashboardItemViewConfiguration> getDashboardItemConfigs() {
        return this.items;
    }

    public boolean isOpenConnectionOnActivate() {
        return this.openConnectionOnActivate;
    }

    public void setOpenConnectionOnActivate(boolean openConnectionOnActivate) {
        this.openConnectionOnActivate = openConnectionOnActivate;
    }

    public boolean isUseSeparateConnection() {
        return this.useSeparateConnection;
    }

    public void setUseSeparateConnection(boolean useSeparateConnection) {
        this.useSeparateConnection = useSeparateConnection;
    }

    public DashboardItemViewConfiguration getDashboardConfig(String dashboardId) {
        for (DashboardItemViewConfiguration item : this.items) {
            if (!item.getDashboardDescriptor().getId().equals(dashboardId)) continue;
            return item;
        }
        return null;
    }

    public DashboardItemViewConfiguration readDashboardConfiguration(DashboardDescriptor dashboard) {
        DashboardItemViewConfiguration dashboardConfig = this.getDashboardConfig(dashboard.getId());
        if (dashboardConfig != null) {
            return dashboardConfig;
        }
        DashboardItemViewConfiguration itemViewConfiguration = new DashboardItemViewConfiguration(dashboard, this.items.size());
        this.items.add(itemViewConfiguration);
        return itemViewConfiguration;
    }

    public void removeDashboard(String dashboardId) {
        int decValue = 0;
        int i = 0;
        while (i < this.items.size()) {
            DashboardItemViewConfiguration item = this.items.get(i);
            if (item.getDashboardDescriptor().getId().equals(dashboardId)) {
                this.items.remove(i);
                ++decValue;
                continue;
            }
            item.setIndex(item.getIndex() - decValue);
            ++i;
        }
    }

    public void updateDashboardConfig(DashboardItemViewConfiguration config) {
        DashboardItemViewConfiguration curConfig = this.getDashboardConfig(config.getDashboardDescriptor().getId());
        if (curConfig == null) {
            this.items.add(config);
        } else {
            curConfig.copyFrom(config);
        }
    }

    public void clearDashboards() {
        this.items.clear();
    }

    private void loadSettings() {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            return;
        }
        try {
            Document document = XMLUtils.parseDocument((File)configFile);
            for (Element viewElement : XMLUtils.getChildElementList((Element)document.getDocumentElement(), (String)"view")) {
                this.openConnectionOnActivate = CommonUtils.getBoolean((String)viewElement.getAttribute("openConnectionOnActivate"), (boolean)this.openConnectionOnActivate);
                this.useSeparateConnection = CommonUtils.getBoolean((String)viewElement.getAttribute("useSeparateConnection"), (boolean)this.useSeparateConnection);
            }
            for (Element dbElement : XMLUtils.getChildElementList((Element)document.getDocumentElement(), (String)"dashboard")) {
                String dashboardId = dbElement.getAttribute("id");
                DashboardDescriptor dashboard = DashboardRegistry.getInstance().getDashboard(dashboardId);
                if (dashboard != null) {
                    DashboardItemViewConfiguration itemConfig = new DashboardItemViewConfiguration(dashboard, dbElement);
                    this.items.add(itemConfig);
                    continue;
                }
                log.warn((Object)("Dashboard '" + dashboardId + "' not found"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading dashboard view configuration", (Throwable)e);
        }
        this.items.sort(Comparator.comparingInt(DashboardItemViewConfiguration::getIndex));
    }

    public void saveSettings() {
        File configFile = this.getConfigFile();
        if (this.items.isEmpty()) {
            if (configFile.exists() && !configFile.delete()) {
                log.debug((Object)("Can't delete view configuration " + configFile.getAbsolutePath()));
            }
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(configFile);){
                XMLBuilder xml = new XMLBuilder((OutputStream)out, "UTF-8");
                xml.setButify(true);
                xml.startElement("dashboards");
                xml.startElement("view");
                xml.addAttribute("openConnectionOnActivate", this.openConnectionOnActivate);
                xml.addAttribute("useSeparateConnection", this.useSeparateConnection);
                xml.endElement();
                for (DashboardItemViewConfiguration itemConfig : this.items) {
                    xml.startElement("dashboard");
                    itemConfig.serialize(xml);
                    xml.endElement();
                }
                xml.endElement();
                xml.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving dashboard view configuration", (Throwable)e);
        }
    }

    private File getConfigFile() {
        File pluginFolder = UIDashboardActivator.getDefault().getStateLocation().toFile();
        File viewConfigFolder = new File(pluginFolder, "views");
        if (!viewConfigFolder.exists() && !viewConfigFolder.mkdirs()) {
            log.error((Object)("Can't create view config folder " + viewConfigFolder.getAbsolutePath()));
        }
        return new File(viewConfigFolder, "view-" + this.viewId + ".xml");
    }
}

