/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class ServiceRegistry {
    private static final Log log = Log.getLog(ServiceRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.service";
    private static ServiceRegistry instance = null;
    private final Map<String, ServiceDescriptor> services = new HashMap<String, ServiceDescriptor>();

    public static synchronized ServiceRegistry getInstance() {
        if (instance == null) {
            instance = new ServiceRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ServiceRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            ServiceDescriptor service = new ServiceDescriptor(ext);
            this.services.put(service.type.getImplName(), service);
            ++n2;
        }
    }

    @Nullable
    public <T> T getService(@NotNull Class<T> serviceType) {
        ServiceDescriptor descriptor = this.services.get(serviceType.getName());
        if (descriptor != null) {
            if (descriptor.instance == null) {
                try {
                    descriptor.instance = descriptor.impl.createInstance(Object.class);
                }
                catch (DBException e) {
                    log.debug("Error creating service '" + serviceType.getName() + "'", e);
                }
            }
            return (T)descriptor.instance;
        }
        return null;
    }

    private class ServiceDescriptor
    extends AbstractDescriptor {
        private final AbstractDescriptor.ObjectType type;
        private final AbstractDescriptor.ObjectType impl;
        private Object instance;

        ServiceDescriptor(IConfigurationElement config) {
            super(config);
            this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("name"));
            this.impl = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        }
    }
}

