/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;

public abstract class DBVUtils {
    private static final Map<String, DBVEntity> orphanVirtualEntities = new HashMap<String, DBVEntity>();

    @Nullable
    public static DBVTransformSettings getTransformSettings(@NotNull DBDAttributeBinding binding, boolean create) {
        DBVEntityAttribute vAttr;
        DBVEntity vEntity = DBVUtils.getVirtualEntity(binding, create);
        if (vEntity != null && (vAttr = vEntity.getVirtualAttribute(binding, create)) != null) {
            return DBVUtils.getTransformSettings(vAttr, create);
        }
        return null;
    }

    public static DBVEntity getVirtualEntity(@NotNull DBDAttributeBinding binding, boolean create) {
        DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
        DBVEntity vEntity = entityAttribute != null ? DBVUtils.getVirtualEntity(entityAttribute.getParentObject(), create) : DBVUtils.getVirtualEntity(binding.getDataContainer(), create);
        return vEntity;
    }

    @Nullable
    public static DBVEntity getVirtualEntity(@NotNull DBSEntity source, boolean create) {
        return source.getDataSource().getContainer().getVirtualModel().findEntity(source, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBVEntity getVirtualEntity(@NotNull DBSDataContainer dataContainer, boolean create) {
        String attrKey = DBUtils.getObjectFullId(dataContainer);
        Map<String, DBVEntity> map = orphanVirtualEntities;
        synchronized (map) {
            DBVEntity vEntity = orphanVirtualEntities.get(attrKey);
            if (vEntity == null && create) {
                vEntity = new DBVEntity(dataContainer.getDataSource().getContainer().getVirtualModel(), dataContainer.getName(), "");
                orphanVirtualEntities.put(attrKey, vEntity);
            }
            return vEntity;
        }
    }

    @Nullable
    private static DBVTransformSettings getTransformSettings(@NotNull DBVEntityAttribute attribute, boolean create) {
        if (attribute.getTransformSettings() != null) {
            return attribute.getTransformSettings();
        }
        if (create) {
            attribute.setTransformSettings(new DBVTransformSettings());
            return attribute.getTransformSettings();
        }
        DBVObject object = attribute.getParentObject();
        while (object != null) {
            if (object.getTransformSettings() != null) {
                return object.getTransformSettings();
            }
            object = ((DBVObject)object).getParentObject();
        }
        return null;
    }

    @NotNull
    public static Map<String, String> getAttributeTransformersOptions(@NotNull DBDAttributeBinding binding) {
        Map<String, String> options = null;
        DBVTransformSettings transformSettings = DBVUtils.getTransformSettings(binding, false);
        if (transformSettings != null) {
            options = transformSettings.getTransformOptions();
        }
        if (options != null) {
            return options;
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static DBDAttributeTransformer[] findAttributeTransformers(@NotNull DBDAttributeBinding binding, @Nullable Boolean custom) {
        DBPDataSource dataSource = binding.getDataSource();
        DBPDataSourceContainer container = dataSource.getContainer();
        List<? extends DBDAttributeTransformerDescriptor> tdList = container.getPlatform().getValueHandlerRegistry().findTransformers(dataSource, binding.getAttribute(), custom);
        if (tdList == null || tdList.isEmpty()) {
            return null;
        }
        boolean filtered = false;
        DBVTransformSettings transformSettings = DBVUtils.getTransformSettings(binding, false);
        if (transformSettings != null) {
            filtered = transformSettings.filterTransformers(tdList);
        }
        if (!filtered) {
            int i = 0;
            while (i < tdList.size()) {
                if (tdList.get(i).isCustom() || !tdList.get(i).isApplicableByDefault()) {
                    tdList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (tdList.isEmpty()) {
            return null;
        }
        DBDAttributeTransformer[] result = new DBDAttributeTransformer[tdList.size()];
        int i = 0;
        while (i < tdList.size()) {
            result[i] = (DBDAttributeTransformer)tdList.get(i).getInstance();
            ++i;
        }
        return result;
    }

    public static String getDictionaryDescriptionColumns(DBRProgressMonitor monitor, DBSEntityAttribute attribute) throws DBException {
        DBVEntity dictionary = DBVUtils.getVirtualEntity(attribute.getParentObject(), false);
        String descColumns = null;
        if (dictionary != null) {
            descColumns = dictionary.getDescriptionColumnNames();
        }
        if (descColumns == null) {
            descColumns = DBVEntity.getDefaultDescriptionColumn(monitor, attribute);
        }
        return descColumns;
    }

    @NotNull
    public static List<DBDLabelValuePair> readDictionaryRows(DBCSession session, DBSEntityAttribute valueAttribute, DBDValueHandler valueHandler, DBCResultSet dbResult) throws DBCException {
        ArrayList<DBDLabelValuePair> values = new ArrayList<DBDLabelValuePair>();
        List<DBCAttributeMetaData> metaColumns = dbResult.getMeta().getAttributes();
        ArrayList<DBDValueHandler> colHandlers = new ArrayList<DBDValueHandler>(metaColumns.size());
        for (DBCAttributeMetaData col : metaColumns) {
            colHandlers.add(DBUtils.findValueHandler(session, (DBSTypedObject)col));
        }
        boolean hasNulls = false;
        while (dbResult.nextRow()) {
            String keyLabel;
            if (session.getProgressMonitor().isCanceled()) break;
            Object keyValue = valueHandler.fetchValueObject(session, dbResult, valueAttribute, 0);
            if (DBUtils.isNullValue(keyValue)) {
                if (hasNulls) continue;
                hasNulls = true;
            }
            if (metaColumns.size() > 1) {
                StringBuilder keyLabel2 = new StringBuilder();
                int i = 1;
                while (i < colHandlers.size()) {
                    Object descValue = ((DBDValueHandler)colHandlers.get(i)).fetchValueObject(session, dbResult, metaColumns.get(i), i);
                    if (keyLabel2.length() > 0) {
                        keyLabel2.append(" ");
                    }
                    keyLabel2.append(((DBDValueHandler)colHandlers.get(i)).getValueDisplayString(metaColumns.get(i), descValue, DBDDisplayFormat.NATIVE));
                    ++i;
                }
                keyLabel = keyLabel2.toString();
            } else {
                keyLabel = valueHandler.getValueDisplayString(valueAttribute, keyValue, DBDDisplayFormat.NATIVE);
            }
            values.add(new DBDLabelValuePair(keyLabel, keyValue));
        }
        return values;
    }
}

