/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;

public class DBVEntityForeignKey
implements DBSEntityConstraint,
DBSEntityReferrer,
DBSEntityAssociation {
    @NotNull
    private final DBVEntity entity;
    private final DBSEntityConstraint refEntityConstraint;
    private final List<DBVEntityForeignKeyColumn> attributes = new ArrayList<DBVEntityForeignKeyColumn>();

    public DBVEntityForeignKey(DBVEntity entity, DBSEntityConstraint refEntityConstraint) throws DBException {
        this.entity = entity;
        this.refEntityConstraint = refEntityConstraint;
    }

    public DBVEntityForeignKey(@NotNull DBVEntity entity, DBVEntityForeignKey copy) {
        this.entity = entity;
        this.refEntityConstraint = copy.refEntityConstraint;
    }

    @Override
    public DBSEntityConstraint getReferencedConstraint() {
        return this.refEntityConstraint;
    }

    @Override
    public DBSEntity getAssociatedEntity() {
        return this.refEntityConstraint.getParentObject();
    }

    public List<DBVEntityForeignKeyColumn> getAttributeReferences(@Nullable DBRProgressMonitor monitor) {
        return this.attributes;
    }

    public synchronized void setAttributes(List<DBVEntityForeignKeyColumn> attrs) {
        this.attributes.clear();
        this.attributes.addAll(attrs);
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public DBVEntity getParentObject() {
        return this.entity;
    }

    @NotNull
    public DBVEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.entity.getDataSource();
    }

    @Override
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.VIRTUAL_FOREIGN_KEY;
    }

    @Override
    @NotNull
    public String getName() {
        return String.valueOf(this.entity.getName()) + " " + this.getConstraintType().getName();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }
}

