/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.DBSStructCache;
import org.jkiss.dbeaver.model.impl.SimpleObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class JDBCStructCache<OWNER extends DBSObject, OBJECT extends DBSObject, CHILD extends DBSObject>
extends JDBCObjectCache<OWNER, OBJECT>
implements DBSStructCache<OWNER, OBJECT, CHILD> {
    private static final Log log = Log.getLog(JDBCStructCache.class);
    private final Object objectNameColumn;
    private volatile boolean childrenCached = false;
    private final Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> childrenCache = new IdentityHashMap<OBJECT, SimpleObjectCache<OBJECT, CHILD>>();

    protected abstract JDBCStatement prepareChildrenStatement(@NotNull JDBCSession var1, @NotNull OWNER var2, @Nullable OBJECT var3) throws SQLException;

    protected abstract CHILD fetchChild(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull OBJECT var3, @NotNull JDBCResultSet var4) throws SQLException, DBException;

    protected JDBCStructCache(Object objectNameColumn) {
        this.objectNameColumn = objectNameColumn;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void loadChildren(DBRProgressMonitor monitor, OWNER owner, @Nullable OBJECT forObject) throws DBException {
        if (forObject == null) {
            if (this.childrenCached != false) return;
        }
        if (forObject != null) {
            if (forObject.isPersisted() == false) return;
            if (this.isChildrenCached(forObject) != false) return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (forObject == null) {
            super.loadObjects(monitor, owner);
        }
        if ((dataSource = owner.getDataSource()) == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession(monitor, owner, "Load child objects");
                try {
                    objectMap = new HashMap<OBJECT, ArrayList<CHILD>>();
                    var9_12 = null;
                    var10_14 = null;
                    try {
                        dbStat = this.prepareChildrenStatement(session, owner, forObject);
                        dbStat.setFetchSize(1000);
                        dbStat.executeStatement();
                        dbResult = dbStat.getResultSet();
                        if (dbResult == null) return;
                        try {
                            block32: {
                                if (dbResult.next()) {
                                }
                                if (monitor.isCanceled()) {
                                    if (session == null) return;
                                    session.close();
                                    return;
                                }
                                for (Map.Entry<K, V> colEntry : objectMap.entrySet()) {
                                    if (this.isChildrenCached((DBSObject)colEntry.getKey())) continue;
                                    this.cacheChildren((DBSObject)colEntry.getKey(), (List)colEntry.getValue());
                                }
                                if (forObject != null) break block32;
                                if (objectMap.isEmpty() != false) return;
                                var14_19 = this.getAllObjects(monitor, owner).iterator();
                                if (true) ** GOTO lbl54
                            }
                            if (objectMap.containsKey(forObject) != false) return;
                            this.cacheChildren(forObject, new ArrayList<E>());
                            return;
                            finally {
                                dbResult.close();
                            }
                            do {
                                if (this.isChildrenCached(tmpObject = (DBSObject)var14_19.next()) || objectMap.containsKey(tmpObject)) continue;
                                this.cacheChildren(tmpObject, new ArrayList<E>());
lbl54:
                                // 3 sources

                            } while (var14_19.hasNext());
                            this.childrenCached = true;
                            return;
                        }
                        finally {
                            if (dbStat == null) {
                                if (session == null) return;
                                session.close();
                                return;
                            }
                            dbStat.close();
                        }
                    }
                    catch (Throwable var10_15) {
                        if (var9_12 == null) {
                            var9_12 = var10_15;
                            throw var9_12;
                        }
                        if (var9_12 == var10_15) throw var9_12;
                        var9_12.addSuppressed(var10_15);
                        throw var9_12;
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                    throw var5_5;
                }
                if (var5_5 == var6_9) throw var5_5;
                var5_5.addSuppressed(var6_9);
                throw var5_5;
            }
        }
        catch (SQLException ex) {
            throw new DBException(ex, dataSource);
        }
    }

    @Override
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        this.clearChildrenCache(object);
    }

    @Override
    public void clearCache() {
        this.clearChildrenCache(null);
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBSObjectCache<OBJECT, CHILD> getChildrenCache(OBJECT forObject) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<Object, Object> nestedCache = this.childrenCache.get(forObject);
            if (nestedCache == null) {
                nestedCache = new SimpleObjectCache();
                nestedCache.setCache(new ArrayList());
                this.childrenCache.put(forObject, nestedCache);
            }
            return nestedCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<CHILD> getChildren(DBRProgressMonitor monitor, OWNER owner, OBJECT forObject) throws DBException {
        this.loadChildren(monitor, owner, forObject);
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            return nestedCache == null ? null : nestedCache.getAllObjects(monitor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CHILD getChild(DBRProgressMonitor monitor, OWNER owner, OBJECT forObject, String objectName) throws DBException {
        this.loadChildren(monitor, owner, forObject);
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<OBJECT, CHILD> nestedCache = this.childrenCache.get(forObject);
            return nestedCache == null ? null : (CHILD)nestedCache.getObject(monitor, forObject, objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearChildrenCache(OBJECT forParent) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            if (forParent != null) {
                this.childrenCache.remove(forParent);
            } else {
                this.childrenCache.clear();
            }
            this.childrenCached = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isChildrenCached(OBJECT parent) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            return this.childrenCache.containsKey(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheChildren(OBJECT parent, List<CHILD> children) {
        Map<OBJECT, SimpleObjectCache<OBJECT, CHILD>> map = this.childrenCache;
        synchronized (map) {
            SimpleObjectCache<Object, Object> nestedCache = this.childrenCache.get(parent);
            if (nestedCache == null) {
                nestedCache = new SimpleObjectCache();
                nestedCache.setCaseSensitive(this.caseSensitive);
                this.childrenCache.put(parent, nestedCache);
            }
            nestedCache.setCache(children);
        }
    }
}

