/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.json;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public class JSONUtils {
    private static final Log log = Log.getLog(JSONUtils.class);
    private static SimpleDateFormat dateFormat;

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(tz);
    }

    public static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public static Date parseDate(String str) {
        if (CommonUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            return dateFormat.parse(str);
        }
        catch (ParseException parseException) {
            log.error("Error parsing date");
            return new Date(0L);
        }
    }

    public static String formatISODate(Date date) {
        return "ISODate(\"" + JSONUtils.formatDate(date) + "\")";
    }

    public static String escapeJsonString(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    result.append("\\").append(c);
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

