/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;

public class JDBCContentBytes
extends JDBCContentAbstract
implements DBDContentStorage,
DBDContentCached {
    private static final Log log = Log.getLog(JDBCContentBytes.class);
    private byte[] originalData;
    private byte[] data;

    public JDBCContentBytes(DBPDataSource dataSource) {
        super(dataSource);
        this.originalData = null;
        this.data = null;
    }

    public JDBCContentBytes(DBPDataSource dataSource, byte[] data) {
        super(dataSource);
        this.originalData = data;
        this.data = data;
    }

    public JDBCContentBytes(DBPDataSource dataSource, String data) {
        super(dataSource);
        this.originalData = DBValueFormatting.getBinaryPresentation(dataSource).toBytes(data);
        this.data = this.originalData;
    }

    private JDBCContentBytes(JDBCContentBytes copyFrom) {
        super(copyFrom);
        this.originalData = copyFrom.originalData;
        this.data = copyFrom.data;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        if (this.data == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public Reader getContentReader() throws IOException {
        return new InputStreamReader(this.getContentStream());
    }

    @Override
    public long getContentLength() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.length;
    }

    @Override
    public String getCharset() {
        return DBValueFormatting.getDefaultBinaryFileEncoding(this.dataSource);
    }

    @Override
    public JDBCContentBytes cloneStorage(DBRProgressMonitor monitor) throws IOException {
        return this.cloneValue(monitor);
    }

    @Override
    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateContents(DBRProgressMonitor monitor, DBDContentStorage storage) throws DBException {
        if (storage == null) {
            this.data = null;
        } else {
            try {
                InputStream is = storage.getContentStream();
                try {
                    byte[] newData = new byte[(int)storage.getContentLength()];
                    int count = is.read(newData);
                    if (count != newData.length) {
                        log.warn("Actual content length (" + count + ") is less than declared (" + newData.length + ")");
                    }
                    if (this.data != null && Arrays.equals(this.data, newData)) {
                        return false;
                    }
                    this.data = newData;
                }
                finally {
                    ContentUtils.close(is);
                }
            }
            catch (IOException e) {
                throw new DBCException("IO error while reading content", e);
            }
        }
        this.modified = true;
        return false;
    }

    @Override
    public void resetContents() {
        this.data = this.originalData;
        this.modified = false;
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        try {
            if (this.data != null) {
                preparedStatement.setBytes(paramIndex, this.data);
            } else {
                preparedStatement.setNull(paramIndex, columnType.getTypeID());
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.dataSource);
        }
    }

    public byte[] getRawValue() {
        return this.data;
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void release() {
        this.data = this.originalData;
    }

    @Override
    public String getDisplayString(DBDDisplayFormat format) {
        if (this.data == null) {
            return null;
        }
        return DBValueFormatting.formatBinaryString(this.dataSource, this.data, format);
    }

    @Override
    public JDBCContentBytes cloneValue(DBRProgressMonitor monitor) {
        return new JDBCContentBytes(this);
    }

    @Override
    public Object getCachedValue() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JDBCContentBytes) {
            byte[] data2 = ((JDBCContentBytes)obj).data;
            if (this.data == null) {
                return data2 == null;
            }
            if (data2 != null) {
                return Arrays.equals(this.data, data2);
            }
        }
        return false;
    }
}

