/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeValue {
    @NotNull
    private final DBSAttributeBase attribute;
    @Nullable
    private final Object value;

    public DBDAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) {
        this.attribute = attribute;
        this.value = value;
    }

    @NotNull
    public DBSAttributeBase getAttribute() {
        return this.attribute;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.attribute.getName()) + "=" + this.value;
    }

    public static DBSAttributeBase[] getAttributes(List<DBDAttributeValue> attrValues) {
        DBSAttributeBase[] attributes = new DBSAttributeBase[attrValues.size()];
        int i = 0;
        while (i < attributes.length) {
            attributes[i] = attrValues.get((int)i).attribute;
            ++i;
        }
        return attributes;
    }

    public static Object[] getValues(List<DBDAttributeValue> attrValues) {
        Object[] values = new Object[attrValues.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = attrValues.get((int)i).value;
            ++i;
        }
        return values;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DBDAttributeValue)) {
            return false;
        }
        if (!CommonUtils.equalObjects((Object)this.value, (Object)((DBDAttributeValue)obj).value)) {
            return false;
        }
        return CommonUtils.equalObjects((Object)this.attribute.getName(), (Object)((DBDAttributeValue)obj).attribute.getName());
    }
}

