/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjection;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjectionColumn;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaUDF;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;

public class VerticaSchema
extends GenericSchema
implements DBPSystemObject {
    private static final Log log = Log.getLog(VerticaSchema.class);
    private static final String[] SYSTEM_SCHEMAS = new String[]{"v_catalog", "v_internal", "v_monitor", "v_txtindex"};
    final ProjectionCache projectionCache = new ProjectionCache();
    final UDFCache udfCache = new UDFCache();
    final Set<String> flexTablNames = new HashSet<String>();

    public VerticaSchema(GenericDataSource dataSource, GenericCatalog catalog, String schemaName) {
        super(dataSource, catalog, schemaName);
    }

    public ProjectionCache getProjectionCache() {
        return this.projectionCache;
    }

    public Collection<? extends DBSObject> getChildren(DBRProgressMonitor monitor) throws DBException {
        ArrayList children = new ArrayList(this.getTables(monitor));
        return children;
    }

    @Association
    public Collection<GenericTable> getFlexTables(DBRProgressMonitor monitor) throws DBException {
        Collection tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<GenericTable> filtered = new ArrayList<GenericTable>();
            for (GenericTable table : tables) {
                if (!(table instanceof VerticaTable) || !this.flexTablNames.contains(table.getName())) continue;
                filtered.add(table);
            }
            return filtered;
        }
        return null;
    }

    @Association
    public Collection<VerticaProjection> getProjections(DBRProgressMonitor monitor) throws DBException {
        return this.projectionCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public VerticaProjection getProjection(DBRProgressMonitor monitor, String name) throws DBException {
        return (VerticaProjection)this.projectionCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<VerticaUDF> getUserDefinedFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.udfCache.getAllObjects(monitor, (DBSObject)this);
    }

    public boolean isSystem() {
        return ArrayUtils.contains((Object[])SYSTEM_SCHEMAS, (Object)this.getName());
    }

    boolean isFlexTableName(String tableName) {
        return this.flexTablNames.contains(tableName);
    }

    public void cacheFlexTableName(String tableName) {
        this.flexTablNames.add(tableName);
    }

    public class ProjectionCache
    extends JDBCStructLookupCache<VerticaSchema, VerticaProjection, VerticaProjectionColumn> {
        ProjectionCache() {
            super((Object)"projection_name");
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull VerticaSchema schema, @Nullable VerticaProjection object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.*,c.comment FROM v_catalog.projections p\nLEFT OUTER JOIN v_catalog.comments c ON c.object_type = 'PROJECTION' AND c.object_schema = p.projection_schema AND c.object_name = p.projection_name\nWHERE p.projection_schema=?" + (object == null && objectName == null ? "" : " AND projection_name=?"));
            dbStat.setString(1, schema.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected VerticaProjection fetchObject(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaProjection(VerticaSchema.this, dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @Nullable VerticaProjection forTable) throws SQLException {
            String sql = "SELECT pc.*,c.comment FROM v_catalog.projection_columns pc\nLEFT OUTER JOIN v_catalog.comments c ON c.object_id = pc.column_id\nWHERE pc.projection_id=?\nORDER BY pc.column_position";
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            dbStat.setLong(1, forTable.getObjectId());
            return dbStat;
        }

        protected VerticaProjectionColumn fetchChild(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @NotNull VerticaProjection table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaProjectionColumn(table, dbResult);
        }
    }

    public class UDFCache
    extends JDBCObjectLookupCache<VerticaSchema, VerticaUDF> {
        UDFCache() {
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull VerticaSchema schema, @Nullable VerticaUDF object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM v_catalog.user_functions WHERE schema_schema=?" + (object == null && objectName == null ? "" : " AND function_name=?"));
            dbStat.setString(1, schema.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected VerticaUDF fetchObject(@NotNull JDBCSession session, @NotNull VerticaSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaUDF(VerticaSchema.this, dbResult);
        }
    }
}

