/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreConstraintManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public class PostgreForeignKeyManager
extends SQLForeignKeyManager<PostgreTableForeignKey, PostgreTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableForeignKey> getObjectsCache(PostgreTableForeignKey object) {
        PostgreTableBase parent = (PostgreTableBase)object.getParentObject();
        if (parent instanceof PostgreTable) {
            return ((PostgreTable)parent).getForeignKeyCache();
        }
        return null;
    }

    protected PostgreTableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, PostgreTableBase table, Object from) {
        PostgreTableForeignKey foreignKey = new PostgreTableForeignKey(table, null, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.NO_ACTION);
        foreignKey.setName(this.getNewConstraintName(monitor, foreignKey));
        return foreignKey;
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreTableBase owner, DBECommandAbstract<PostgreTableForeignKey> command, Map<String, Object> options) {
        PostgreTableForeignKey fk = (PostgreTableForeignKey)command.getObject();
        if (fk.isPersisted()) {
            try {
                String constrDDL = fk.getObjectDefinitionText(monitor, Collections.singletonMap("embedded.source", true));
                if (!CommonUtils.isEmpty((String)constrDDL)) {
                    return new StringBuilder(constrDDL);
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract FK DDL", (Throwable)e);
            }
        }
        StringBuilder sql = super.getNestedDeclaration(monitor, (JDBCTable)owner, command, options);
        if (fk.isDeferrable()) {
            sql.append(" DEFERRABLE");
        }
        if (fk.isDeferred()) {
            sql.append(" INITIALLY DEFERRED");
        }
        return sql;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            PostgreConstraintManager.addConstraintCommentAction(actionList, (PostgreTableConstraintBase)command.getObject());
        }
    }

    protected String getDropForeignKeyPattern(PostgreTableForeignKey foreignKey) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }
}

