/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class PostgreCreateDatabaseDialog
extends BaseDialog {
    private final PostgreDataSource dataSource;
    private List<PostgreRole> allUsers;
    private List<PostgreCharset> allEncodings;
    private List<PostgreCollation> allCollations;
    private List<PostgreTablespace> allTablespaces;
    private List<String> allTemplates;
    private String name;
    private PostgreRole owner;
    private String dbTemplate;
    private PostgreCharset encoding;
    private PostgreTablespace tablespace;
    private Combo userCombo;
    private Combo encodingCombo;
    private Combo tablespaceCombo;
    private Combo templateCombo;

    public PostgreCreateDatabaseDialog(Shell parentShell, PostgreDataSource dataSource) {
        super(parentShell, PostgreMessages.dialog_create_db_title, null);
        this.dataSource = dataSource;
    }

    protected Composite createDialogArea(Composite parent) {
        final boolean supportsRoles = this.dataSource.isServerVersionAtLeast(8, 1);
        final boolean supportsEncodings = this.dataSource.getServerType().supportsEncodings();
        final boolean supportsTablespaces = this.dataSource.getServerType().supportsTablespaces();
        boolean supportsTemplates = this.dataSource.getServerType().supportsTemplates();
        Composite composite = super.createDialogArea(parent);
        Group groupGeneral = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.dialog_create_db_group_general, (int)2, (int)768, (int)0);
        Text nameText = UIUtils.createLabelText((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_db_name, (String)"");
        nameText.addModifyListener(e -> {
            this.name = nameText.getText();
            this.getButton(0).setEnabled(!this.name.isEmpty());
        });
        if (supportsRoles) {
            this.userCombo = UIUtils.createLabelCombo((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_owner, (int)2060);
            this.userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PostgreCreateDatabaseDialog.this.owner = (PostgreRole)PostgreCreateDatabaseDialog.this.allUsers.get(PostgreCreateDatabaseDialog.this.userCombo.getSelectionIndex());
                }
            });
        }
        Group groupDefinition = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.dialog_create_db_group_definition, (int)2, (int)768, (int)0);
        if (supportsTemplates) {
            this.templateCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_template_db, (int)2060);
            this.templateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PostgreCreateDatabaseDialog.this.dbTemplate = PostgreCreateDatabaseDialog.this.templateCombo.getText();
                }
            });
        }
        if (supportsEncodings) {
            this.encodingCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_encoding, (int)2060);
            this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PostgreCreateDatabaseDialog.this.encoding = (PostgreCharset)PostgreCreateDatabaseDialog.this.allEncodings.get(PostgreCreateDatabaseDialog.this.encodingCombo.getSelectionIndex());
                }
            });
        }
        if (supportsTablespaces) {
            this.tablespaceCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_tablesapce, (int)2060);
            this.tablespaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (PostgreCreateDatabaseDialog.this.tablespaceCombo.getSelectionIndex() == 0) {
                        PostgreCreateDatabaseDialog.this.tablespace = null;
                    } else {
                        PostgreCreateDatabaseDialog.this.tablespace = (PostgreTablespace)PostgreCreateDatabaseDialog.this.allTablespaces.get(PostgreCreateDatabaseDialog.this.tablespaceCombo.getSelectionIndex());
                    }
                }
            });
        }
        new AbstractJob("Load users"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    PostgreDatabase database = PostgreCreateDatabaseDialog.this.dataSource.getDefaultInstance();
                    PostgreCreateDatabaseDialog.this.allUsers = supportsRoles ? new ArrayList(database.getUsers(monitor)) : null;
                    PostgreCreateDatabaseDialog.this.allEncodings = supportsEncodings ? new ArrayList(database.getEncodings(monitor)) : null;
                    PostgreCreateDatabaseDialog.this.allTablespaces = supportsTablespaces ? new ArrayList(database.getTablespaces(monitor)) : null;
                    PostgreCreateDatabaseDialog.this.allTemplates = new ArrayList(PostgreCreateDatabaseDialog.this.dataSource.getTemplateDatabases(monitor));
                    PostgreRole dba = supportsRoles ? database.getDBA(monitor) : null;
                    String defUserName = dba == null ? "" : dba.getName();
                    PostgreCharset defCharset = supportsEncodings ? database.getDefaultEncoding(monitor) : null;
                    PostgreTablespace defTablespace = supportsTablespaces ? database.getDefaultTablespace(monitor) : null;
                    UIUtils.syncExec(() -> {
                        if (PostgreCreateDatabaseDialog.this.userCombo != null) {
                            for (PostgreRole authId : PostgreCreateDatabaseDialog.this.allUsers) {
                                String name = authId.getName();
                                PostgreCreateDatabaseDialog.this.userCombo.add(name);
                                if (!name.equals(defUserName)) continue;
                                PostgreCreateDatabaseDialog.this.owner = authId;
                            }
                            PostgreCreateDatabaseDialog.this.userCombo.setText(defUserName);
                        }
                        if (PostgreCreateDatabaseDialog.this.templateCombo != null) {
                            PostgreCreateDatabaseDialog.this.templateCombo.add("");
                            for (String tpl : PostgreCreateDatabaseDialog.this.allTemplates) {
                                PostgreCreateDatabaseDialog.this.templateCombo.add(tpl);
                            }
                        }
                        if (PostgreCreateDatabaseDialog.this.encodingCombo != null) {
                            for (PostgreCharset charset : PostgreCreateDatabaseDialog.this.allEncodings) {
                                PostgreCreateDatabaseDialog.this.encodingCombo.add(charset.getName());
                                if (charset != defCharset) continue;
                                PostgreCreateDatabaseDialog.this.encoding = defCharset;
                            }
                            if (defCharset != null) {
                                PostgreCreateDatabaseDialog.this.encodingCombo.setText(defCharset.getName());
                            }
                        }
                        if (PostgreCreateDatabaseDialog.this.tablespaceCombo != null) {
                            PostgreCreateDatabaseDialog.this.tablespaceCombo.add(PostgreMessages.dialog_create_db_tablespace_default);
                            for (PostgreTablespace ts : PostgreCreateDatabaseDialog.this.allTablespaces) {
                                PostgreCreateDatabaseDialog.this.tablespaceCombo.add(ts.getName());
                                if (ts != defTablespace) continue;
                                PostgreCreateDatabaseDialog.this.tablespace = ts;
                            }
                            PostgreCreateDatabaseDialog.this.tablespaceCombo.setText(defTablespace.getName());
                        }
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public PostgreRole getOwner() {
        return this.owner;
    }

    public String getTemplateName() {
        return this.dbTemplate;
    }

    public PostgreCharset getEncoding() {
        return this.encoding;
    }

    public PostgreTablespace getTablespace() {
        return this.tablespace;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

