/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.editors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerSession;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerSessionManager;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;
import org.jkiss.utils.CommonUtils;

public class OracleSessionEditor
extends AbstractSessionEditor {
    private DisconnectSessionAction killSessionAction;
    private DisconnectSessionAction disconnectSessionAction;

    public void createEditorControl(Composite parent) {
        this.killSessionAction = new DisconnectSessionAction(true);
        this.disconnectSessionAction = new DisconnectSessionAction(false);
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<OracleServerSession>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new OracleServerSessionManager(this.getExecutionContext())){
            private boolean showBackground;
            private boolean showInactive;

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)OracleSessionEditor.this.killSessionAction);
                contributionManager.add((IAction)OracleSessionEditor.this.disconnectSessionAction);
                contributionManager.add((IContributionItem)new Separator());
                contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show background", 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
                        this.setToolTipText("Show background tasks");
                        this.setChecked(showBackground);
                    }

                    public void run() {
                        showBackground = this.isChecked();
                        OracleSessionEditor.this.refreshPart((Object)OracleSessionEditor.this, true);
                    }
                }, (boolean)true));
                contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show inactive", 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
                        this.setToolTipText("Show inactive sessions");
                        this.setChecked(showInactive);
                    }

                    public void run() {
                        showInactive = this.isChecked();
                        OracleSessionEditor.this.refreshPart((Object)OracleSessionEditor.this, true);
                    }
                }, (boolean)true));
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                OracleSessionEditor.this.killSessionAction.setEnabled(session != null);
                OracleSessionEditor.this.disconnectSessionAction.setEnabled(session != null);
            }

            protected void loadSettings(IDialogSettings settings) {
                this.showBackground = CommonUtils.toBoolean((Object)settings.get("showBackground"));
                this.showInactive = CommonUtils.toBoolean((Object)settings.get("showInactive"));
                super.loadSettings(settings);
            }

            protected void saveSettings(IDialogSettings settings) {
                super.saveSettings(settings);
                settings.put("showBackground", this.showBackground);
                settings.put("showInactive", this.showInactive);
            }

            public Map<String, Object> getSessionOptions() {
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (this.showBackground) {
                    options.put("showBackground", true);
                }
                if (this.showInactive) {
                    options.put("showInactive", true);
                }
                return options;
            }
        };
    }

    private class DisconnectSessionAction
    extends Action {
        private final boolean kill;

        DisconnectSessionAction(boolean kill) {
            super(kill ? OracleMessages.editors_oracle_session_editor_title_kill_session : OracleMessages.editors_oracle_session_editor_title_disconnect_session, DBeaverIcons.getImageDescriptor((DBPImage)(kill ? UIIcon.REJECT : UIIcon.SQL_DISCONNECT)));
            this.kill = kill;
        }

        public void run() {
            List sessions = OracleSessionEditor.this.getSessionsViewer().getSelectedSessions();
            String action = String.valueOf(this.kill ? OracleMessages.editors_oracle_session_editor_action_kill : OracleMessages.editors_oracle_session_editor_action_disconnect) + OracleMessages.editors_oracle_session_editor_action__session;
            ConfirmationDialog dialog = new ConfirmationDialog(OracleSessionEditor.this.getSite().getShell(), action, null, NLS.bind((String)OracleMessages.editors_oracle_session_editor_confirm_action, (Object)action.toLowerCase(), (Object)sessions), 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, OracleMessages.editors_oracle_session_editor_confirm_title, false);
            if (dialog.open() == 2) {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                if (this.kill) {
                    options.put("killSession", this.kill);
                }
                if (dialog.getToggleState()) {
                    options.put("immediate", true);
                }
                OracleSessionEditor.this.getSessionsViewer().alterSessions(sessions, options);
            }
        }
    }
}

