/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hsqldb.model;

import java.sql.ResultSet;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;

public class HSQLTrigger
extends GenericTrigger {
    private String manipulation;
    private String orientation;
    private String timing;
    private String statement;

    HSQLTrigger(GenericStructContainer container, GenericTable table, String name, JDBCResultSet dbResult) {
        super(container, table, name, null);
        this.manipulation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_MANIPULATION");
        this.orientation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_ORIENTATION");
        this.timing = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_TIMING");
        this.statement = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_STATEMENT");
        if (this.statement != null) {
            this.statement = SQLFormatUtils.formatSQL((SQLDataSource)this.getDataSource(), (String)this.statement);
        }
    }

    @Property(viewable=true, order=11)
    public String getManipulation() {
        return this.manipulation;
    }

    @Property(viewable=true, order=12)
    public String getOrientation() {
        return this.orientation;
    }

    @Property(viewable=true, order=10)
    public String getTiming() {
        return this.timing;
    }

    public String getStatement() {
        return this.statement;
    }
}

