/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GreenplumFunction
extends PostgreProcedure {
    private FunctionExecLocation executionLocation;

    public GreenplumFunction(PostgreSchema schema) {
        super(schema);
        this.executionLocation = ((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(9, 4) ? FunctionExecLocation.a : null;
    }

    public GreenplumFunction(DBRProgressMonitor monitor, PostgreSchema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
        this.executionLocation = this.readExecutionLocationIfSupported(dbResult);
    }

    public FunctionExecLocation getExecutionLocation() {
        return this.executionLocation;
    }

    protected String generateFunctionDeclaration(PostgreLanguage language, String returnTypeName, String functionBody) {
        String functionDeclaration = super.generateFunctionDeclaration(language, returnTypeName, functionBody);
        if (this.executionLocation != null) {
            StringBuilder def = new StringBuilder(functionDeclaration);
            return def.append("EXECUTE ON ").append(this.executionLocation.getValue()).toString();
        }
        return functionDeclaration;
    }

    private FunctionExecLocation readExecutionLocationIfSupported(ResultSet dbResult) {
        return ((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(9, 4) ? (FunctionExecLocation)CommonUtils.valueOf(FunctionExecLocation.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proexeclocation")) : null;
    }

    public static enum FunctionExecLocation {
        a("ANY"),
        m("MASTER"),
        s("ALL SEGMENTS");

        private String execLocation;

        private FunctionExecLocation(String execLocationString) {
            this.execLocation = execLocationString;
        }

        public String getValue() {
            return this.execLocation;
        }
    }
}

