/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericPrimaryKey;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class GenericTableManager
extends SQLTableManager<GenericTable, GenericStructContainer> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{GenericTableColumn.class, GenericPrimaryKey.class, GenericTableForeignKey.class, GenericTableIndex.class};

    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTable> getObjectsCache(GenericTable object) {
        return ((GenericStructContainer)object.getContainer()).getTableCache();
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    protected GenericTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, GenericStructContainer parent, Object copyFrom) {
        String tableName = "";
        try {
            tableName = this.getNewChildName(monitor, parent);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return parent.getDataSource().getMetaModel().createTableImpl(parent, tableName, "TABLE", null);
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        DBPObject object = command.getObject();
        if (object instanceof DBSTableIndex) {
            for (SQLObjectEditor.NestedObjectCommand ccom : orderedCommands) {
                if (!(ccom.getObject() instanceof DBSEntityConstraint) || ccom.getObject() == object || !((DBSEntityConstraint)ccom.getObject()).getConstraintType().isUnique() || !CommonUtils.equalObjects((Object)((DBSTableIndex)object).getName(), (Object)((DBSEntityConstraint)ccom.getObject()).getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<GenericTable, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON TABLE " + ((GenericTable)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((GenericTable)command.getObject()).getDescription())));
        }
    }
}

