/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericPrimaryKey;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.impl.DBPositiveNumberTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCColumnKeyType;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class GenericTableColumn
extends JDBCTableColumn<GenericTable>
implements DBSTableColumn,
DBPNamedObject2,
JDBCColumnKeyType,
DBPOrderedObject {
    private int radix;
    private String remarks;
    private int sourceType;
    private long charLength;
    private boolean autoIncrement;

    public GenericTableColumn(GenericTable table) {
        super((DBSEntity)table, false);
    }

    public GenericTableColumn(GenericTable table, String columnName, String typeName, int valueType, int sourceType, int ordinalPosition, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) {
        super((DBSEntity)table, true, columnName, typeName, valueType, ordinalPosition, columnSize, scale, precision, notNull, autoGenerated || autoIncrement, defaultValue);
        this.sourceType = sourceType;
        this.charLength = charLength;
        this.remarks = remarks;
        this.radix = radix;
        this.autoIncrement = autoIncrement;
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return (GenericDataSource)((GenericTable)this.getTable()).getDataSource();
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public long getCharLength() {
        return this.charLength;
    }

    @Property(viewable=true, editable=true, valueRenderer=DBPositiveNumberTransformer.class, order=41)
    public Integer getScale() {
        return super.getScale();
    }

    @Property(viewable=true, order=51)
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    @Property(viewable=true, editable=true, order=52)
    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public JDBCColumnKeyType getKeyType() {
        return this;
    }

    @Property(viewable=false, valueRenderer=DBPositiveNumberTransformer.class, order=62)
    public int getRadix() {
        return this.radix;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    @Property(viewable=false, order=80)
    public boolean isInUniqueKey() {
        List uniqueKeysCache = ((GenericStructContainer)((GenericTable)this.getTable()).getContainer()).getPrimaryKeysCache().getCachedObjects((DBSObject)((GenericTable)this.getTable()));
        if (!CommonUtils.isEmpty((Collection)uniqueKeysCache)) {
            for (GenericPrimaryKey key : uniqueKeysCache) {
                if (!key.hasColumn(this)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInReferenceKey() {
        return false;
    }

    @Property(viewable=true, editableExpr="object.dataSource.metaModel.tableColumnCommentEditable", updatableExpr="object.dataSource.metaModel.tableColumnCommentEditable", multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String remarks) {
        this.remarks = remarks;
    }

    public String toString() {
        return String.valueOf(((GenericTable)this.getTable()).getFullyQualifiedName(DBPEvaluationContext.UI)) + "." + this.getName();
    }
}

