/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolPriorityGroup
implements DBPRefreshableObject,
DBPNamedObject2,
DBPSaveableObject {
    private ExasolDataSource dataSource;
    private String groupName;
    private Date created;
    private String comment = "";
    private Boolean persisted;
    private int weight;
    private BigDecimal groupId = new BigDecimal(-1);

    public ExasolPriorityGroup(ExasolDataSource dataSource, String name, String comment, int weight) {
        this.groupName = name;
        this.comment = comment;
        this.weight = weight;
        this.persisted = false;
        this.dataSource = dataSource;
    }

    public ExasolPriorityGroup(ExasolDataSource dataSource, ResultSet dbResult) {
        this.dataSource = dataSource;
        if (dbResult != null) {
            this.persisted = true;
            this.groupName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PRIORITY_GROUP_NAME");
            this.created = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"CREATED");
            this.comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PRIORITY_GROUP_COMMENT");
            this.weight = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PRIORITY_GROUP_WEIGHT");
            this.groupId = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"PRIORITY_GROUP_ID");
        }
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getDataSource().refreshObject(monitor);
        return this;
    }

    public void setName(String groupName) {
        this.groupName = groupName;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20)
    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30)
    public String getDescription() {
        return this.comment;
    }

    @Property(viewable=true, editable=false, updatable=false, order=40)
    public BigDecimal getGroupId() {
        return this.groupId;
    }

    @Property(viewable=true, editable=false, updatable=false, order=40)
    public Date getCreated() {
        return this.created;
    }

    @Property(viewable=true, editable=true, updatable=true, order=10)
    public String getName() {
        return this.groupName;
    }
}

