/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolObjectType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class ExasolStructureAssistant
implements DBSStructureAssistant {
    private static final Log LOG = Log.getLog(ExasolStructureAssistant.class);
    private static final DBSObjectType[] SUPP_OBJ_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.VIEW, ExasolObjectType.COLUMN, ExasolObjectType.SCHEMA};
    private static final DBSObjectType[] HYPER_LINKS_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.COLUMN, ExasolObjectType.VIEW, ExasolObjectType.SCHEMA};
    private static final DBSObjectType[] AUTOC_OBJ_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.VIEW, ExasolObjectType.COLUMN, ExasolObjectType.SCHEMA};
    private static final String SQL_TABLES_ALL = "SELECT table_schem,table_name,table_type from \"$ODBCJDBC\".ALL_TABLES WHERE TABLE_NAME = '%s' AND TABLE_TYPE IN (%s)";
    private static final String SQL_TABLES_SCHEMA = "SELECT table_schem,table_name,table_type from \"$ODBCJDBC\".ALL_TABLES WHERE TABLE_SCHEM = '%s' AND TABLE_NAME LIKE ? AND TABLE_TYPE IN (%s)";
    private static final String SQL_COLS_SCHEMA = "SELECT TABLE_SCHEM,TABLE_NAME,COLUMN_NAME from \"$ODBCJDBC\".ALL_COLUMNS WHERE TABLE_SCHEM = '%s' and COLUMN_NAME LIKE '%s'";
    private ExasolDataSource dataSource;

    public ExasolStructureAssistant(ExasolDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return SUPP_OBJ_TYPES;
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return HYPER_LINKS_TYPES;
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return AUTOC_OBJ_TYPES;
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(DBRProgressMonitor monitor, DBSObject parentObject, DBSObjectType[] objectTypes, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults) throws DBException {
        LOG.debug((Object)objectNameMask);
        ArrayList<ExasolObjectType> exasolObjectTypes = new ArrayList<ExasolObjectType>(objectTypes.length);
        DBSObjectType[] dBSObjectTypeArray = objectTypes;
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType dbsObjectType = dBSObjectTypeArray[n2];
            exasolObjectTypes.add((ExasolObjectType)dbsObjectType);
            ++n2;
        }
        ExasolSchema schema = parentObject instanceof ExasolSchema ? (ExasolSchema)parentObject : null;
        try {
            Throwable throwable = null;
            Object var11_11 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Find objects by name");){
                return this.searchAllObjects(session, schema, objectNameMask, exasolObjectTypes, caseSensitive, maxResults);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
    }

    private List<DBSObjectReference> searchAllObjects(JDBCSession session, ExasolSchema schema, String objectNameMask, List<ExasolObjectType> exasolObjectTypes, boolean caseSensitive, int maxResults) throws SQLException, DBException {
        ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
        String searchObjectNameMask = objectNameMask;
        if (!caseSensitive) {
            searchObjectNameMask = searchObjectNameMask.toUpperCase();
        }
        int nbResults = 0;
        if (exasolObjectTypes.contains((Object)ExasolObjectType.TABLE) || exasolObjectTypes.contains((Object)ExasolObjectType.VIEW)) {
            this.searchTables(session, schema, searchObjectNameMask, exasolObjectTypes, maxResults, objects, nbResults);
            if (nbResults >= maxResults) {
                return objects;
            }
        }
        if (exasolObjectTypes.contains((Object)ExasolObjectType.COLUMN)) {
            this.searchColumns(session, schema, searchObjectNameMask, exasolObjectTypes, maxResults, objects, nbResults);
        }
        return objects;
    }

    private void searchTables(JDBCSession session, ExasolSchema schema, String searchObjectNameMask, List<ExasolObjectType> exasolObjectTypes, int maxResults, List<DBSObjectReference> objects, int nbResults) throws SQLException, DBException {
        String sql = schema != null ? String.format(SQL_TABLES_SCHEMA, ExasolUtils.quoteString(schema.getName()), ExasolUtils.quoteString(searchObjectNameMask), this.buildTableTypes(exasolObjectTypes)) : String.format(SQL_TABLES_ALL, ExasolUtils.quoteString(searchObjectNameMask), this.buildTableTypes(exasolObjectTypes));
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCStatement dbStat = session.createStatement();){
            dbStat.setFetchSize(1000);
            Throwable throwable2 = null;
            Object var17_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery(sql);){
                while (dbResult.next()) {
                    if (session.getProgressMonitor().isCanceled()) {
                        break;
                    }
                    if (nbResults++ >= maxResults) {
                        break;
                    }
                    String schemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABLE_SCHEM");
                    String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    ExasolSchema exasolSchema = this.dataSource.getSchema(session.getProgressMonitor(), schemaName);
                    if (exasolSchema == null) {
                        LOG.debug((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    ExasolObjectType objectType = ExasolObjectType.TABLE;
                    objects.add((DBSObjectReference)new ExasolObjectReference(objectName, exasolSchema, objectType));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void searchColumns(JDBCSession session, ExasolSchema schema, String searchObjectNameMask, List<ExasolObjectType> objectTypes, int maxResults, List<DBSObjectReference> objects, int nbResults) throws SQLException, DBException {
        if (schema == null) {
            return;
        }
        sql = String.format("SELECT TABLE_SCHEM,TABLE_NAME,COLUMN_NAME from \"$ODBCJDBC\".ALL_COLUMNS WHERE TABLE_SCHEM = '%s' and COLUMN_NAME LIKE '%s'", new Object[]{ExasolUtils.quoteString(schema.getName()), ExasolUtils.quoteString(searchObjectNameMask)});
        var9_9 = null;
        var10_11 = null;
        try {
            dbStat = session.createStatement();
            try {
                dbStat.setFetchSize(1000);
                var17_14 = null;
                var18_16 = null;
                try {
                    dbResult = dbStat.executeQuery(sql);
                    try {
                        while (true) {
                            if (session.getProgressMonitor().isCanceled()) {
                                break;
                            }
                            if (nbResults++ >= maxResults) {
                                if (dbStat != null) {
                                    dbStat.close();
                                }
                                return;
                            }
                            tableSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABLE_SCHEM");
                            tableOrViewName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                            columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                            exasolSchema = this.dataSource.getSchema(session.getProgressMonitor(), tableSchemaName);
                            if (exasolSchema == null) {
                                ExasolStructureAssistant.LOG.debug((Object)("Schema '" + tableSchemaName + "' not found. Probably was filtered"));
                            }
                            exasolTable = exasolSchema.getTable(session.getProgressMonitor(), tableOrViewName);
                            if (exasolTable != null) {
                                objects.add((DBSObjectReference)new ExasolObjectReference(columnName, exasolTable, ExasolObjectType.COLUMN));
                            }
                            break;
                        }
                    }
                    finally {
                        if (dbResult.next()) ** continue;
                    }
                }
                catch (Throwable var18_17) {
                    if (var17_14 == null) {
                        var17_14 = var18_17;
                    } else if (var17_14 != var18_17) {
                        var17_14.addSuppressed(var18_17);
                    }
                    throw var17_14;
                }
            }
            finally {
                if (dbStat != null) {
                    dbStat.close();
                }
            }
        }
        catch (Throwable var10_12) {
            if (var9_9 == null) {
                var9_9 = var10_12;
            } else if (var9_9 != var10_12) {
                var9_9.addSuppressed(var10_12);
            }
            throw var9_9;
        }
    }

    private String buildTableTypes(List<ExasolObjectType> objectTypes) {
        ArrayList<String> types = new ArrayList<String>();
        for (ExasolObjectType objectType : objectTypes) {
            if (objectType.equals((Object)ExasolObjectType.TABLE)) {
                types.add("'" + ExasolObjectType.TABLE.name() + "'");
            }
            if (!objectType.equals((Object)ExasolObjectType.VIEW)) continue;
            types.add("'" + ExasolObjectType.VIEW.name() + "'");
        }
        return CommonUtils.joinStrings((String)",", types);
    }

    private class ExasolObjectReference
    extends AbstractObjectReference {
        private ExasolObjectReference(String objectName, ExasolSchema exasolSchema, ExasolObjectType objectType) {
            super(objectName, (DBSObject)exasolSchema, null, ExasolSchema.class, (DBSObjectType)objectType);
        }

        private ExasolObjectReference(String objectName, ExasolTable exasolTable, ExasolObjectType objectType) {
            super(objectName, (DBSObject)exasolTable, null, ExasolTable.class, (DBSObjectType)objectType);
        }

        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
            ExasolObjectType exasolObjectType = (ExasolObjectType)this.getObjectType();
            if (this.getContainer() instanceof ExasolSchema) {
                ExasolSchema exasolSchema = (ExasolSchema)this.getContainer();
                DBSObject object = exasolObjectType.findObject(monitor, exasolSchema, this.getName());
                if (object == null) {
                    throw new DBException((Object)((Object)exasolObjectType) + " '" + this.getName() + "' not found in schema '" + exasolSchema.getName() + "'");
                }
                return object;
            }
            if (this.getContainer() instanceof ExasolTable) {
                ExasolTable exasolTable = (ExasolTable)this.getContainer();
                DBSObject object = exasolObjectType.findObject(monitor, exasolTable, this.getName());
                if (object == null) {
                    throw new DBException((Object)((Object)exasolObjectType) + " '" + this.getName() + "' not found in table '" + exasolTable.getName() + "'");
                }
                return object;
            }
            return null;
        }
    }
}

