/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class ExasolViewManager
extends SQLObjectEditor<ExasolView, ExasolSchema>
implements DBEObjectRenamer<ExasolView> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        ExasolTableBase object = (ExasolTableBase)command.getObject();
        if (CommonUtils.isEmpty((String)object.getName())) {
            throw new DBException("View name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((ExasolView)object).getSource())) {
            throw new DBException("View definition cannot be empty");
        }
    }

    public DBSObjectCache<ExasolSchema, ExasolView> getObjectsCache(ExasolView object) {
        return ((ExasolSchema)object.getContainer()).getViewCache();
    }

    protected ExasolView createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, ExasolSchema parent, Object copyFrom) throws DBException {
        ExasolView newView = new ExasolView(parent);
        newView.setName("new_view");
        return newView;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actions, (ExasolView)command.getObject(), false);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        ExasolView view = (ExasolView)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actionList, (ExasolView)command.getObject(), true);
    }

    protected void createOrReplaceViewQuery(List<DBEPersistAction> actions, ExasolView view, Boolean replace) {
        if (replace.booleanValue()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP VIEW " + view.getFullyQualifiedName(DBPEvaluationContext.DDL)));
        }
        try {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", view.getSource()));
            if (!CommonUtils.isEmpty((String)view.getDescription())) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction(String.format("COMMENT ON VIEW %s is '%s'", view.getFullyQualifiedName(DBPEvaluationContext.DDL), ExasolUtils.quoteString(view.getDescription()))));
            }
        }
        catch (DBCException dBCException) {}
    }

    public void renameObject(DBECommandContext commandContext, ExasolView object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolView obj = (ExasolView)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename View", "RENAME VIEW " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }
}

