/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.jkiss.dbeaver.ext.erd.directedit.ExtendedDirectEditManager;
import org.jkiss.dbeaver.ext.erd.directedit.FigureEditorLocator;
import org.jkiss.dbeaver.ext.erd.figures.NoteFigure;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.policy.EntityConnectionEditPolicy;
import org.jkiss.dbeaver.ext.erd.policy.NoteDirectEditPolicy;
import org.jkiss.dbeaver.ext.erd.policy.NoteEditPolicy;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.ui.controls.MultilineTextCellEditor;

public class NotePart
extends NodePart {
    private DirectEditManager manager;

    public ERDNote getNote() {
        return (ERDNote)this.getModel();
    }

    protected void createEditPolicies() {
        boolean editEnabled = this.isEditEnabled();
        if (editEnabled) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new EntityConnectionEditPolicy());
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NoteEditPolicy());
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NoteDirectEditPolicy());
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.performDirectEdit();
        } else if (request.getType() == "direct edit") {
            if (request instanceof DirectEditRequest && !this.directEditHitTest(((DirectEditRequest)request).getLocation().getCopy())) {
                return;
            }
            this.performDirectEdit();
        }
    }

    public Command getCommand(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
        return super.getCommand(request);
    }

    private boolean directEditHitTest(Point requestLoc) {
        NoteFigure figure = (NoteFigure)this.getFigure();
        figure.translateToRelative((Translatable)requestLoc);
        return figure.containsPoint(requestLoc);
    }

    protected void performDirectEdit() {
        if (this.manager == null) {
            NoteFigure figure = (NoteFigure)this.getFigure();
            this.manager = new ExtendedDirectEditManager((GraphicalEditPart)this, MultilineTextCellEditor.class, new FigureEditorLocator((IFigure)figure), (IFigure)figure, value -> null);
        }
        this.manager.show();
    }

    public String toString() {
        return (String)this.getNote().getObject();
    }

    public void handleNameChange(String value) {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setVisible(false);
        this.refreshVisuals();
    }

    public void revertNameChange() {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setText((String)this.getNote().getObject());
        noteFigure.setVisible(true);
        this.refreshVisuals();
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setText((String)this.getNote().getObject());
        noteFigure.setVisible(true);
        this.refreshVisuals();
    }

    protected NoteFigure createFigure() {
        NoteFigure noteFigure = new NoteFigure(this.getNote());
        EntityDiagram.NodeVisualInfo visualInfo = ((DiagramPart)this.getParent()).getDiagram().getVisualInfo(this.getNote(), true);
        Rectangle bounds = visualInfo.initBounds;
        if (bounds != null) {
            noteFigure.setBounds(bounds);
            noteFigure.setPreferredSize(bounds.getSize());
        } else if (noteFigure.getSize().isEmpty()) {
            noteFigure.setPreferredSize(new Dimension(100, 50));
        }
        if (visualInfo.transparent) {
            noteFigure.setOpaque(false);
        }
        if (visualInfo.bgColor != null) {
            noteFigure.setBackgroundColor(visualInfo.bgColor);
        }
        if (visualInfo.fgColor != null) {
            noteFigure.setForegroundColor(visualInfo.fgColor);
        }
        if (visualInfo.borderWidth != 1) {
            noteFigure.setBorder(this.createBorder(visualInfo.borderWidth));
        }
        if (visualInfo.font != null) {
            noteFigure.setFont(visualInfo.font);
        }
        return noteFigure;
    }

    protected void refreshVisuals() {
        NoteFigure notefigure = (NoteFigure)this.getFigure();
        Point location = notefigure.getLocation();
        DiagramPart parent = (DiagramPart)this.getParent();
        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
        parent.setLayoutConstraint((EditPart)this, (IFigure)notefigure, constraint);
    }

    public void setSelected(int value) {
        super.setSelected(value);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public Object getAdapter(Class key) {
        if (key == DBPNamedObject.class) {
            return this.getNote();
        }
        return super.getAdapter(key);
    }

    @Override
    public ERDElement getElement() {
        return this.getNote();
    }
}

