/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;

public class AssociationReconnectSourceCommand
extends Command {
    protected ERDElement sourceEntity;
    protected ERDElement targetEntity;
    protected ERDAssociation association;
    protected ERDElement oldSourceEntity;

    public boolean canExecute() {
        boolean returnVal = true;
        ERDElement primaryEntity = this.association.getTargetEntity();
        if (primaryEntity.equals(this.sourceEntity)) {
            returnVal = false;
        } else {
            List<ERDAssociation> relationships = this.sourceEntity.getAssociations();
            for (ERDAssociation relationship : relationships) {
                if (!relationship.getTargetEntity().equals(this.targetEntity) || !relationship.getSourceEntity().equals(this.sourceEntity)) continue;
                returnVal = false;
                break;
            }
        }
        return returnVal;
    }

    public void execute() {
        if (this.sourceEntity != null) {
            this.oldSourceEntity.removeAssociation(this.association, true);
            this.association.setSourceEntity(this.sourceEntity);
            this.sourceEntity.addAssociation(this.association, true);
        }
    }

    public void setSourceEntity(ERDElement sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public ERDAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(ERDAssociation association) {
        this.association = association;
        this.targetEntity = association.getTargetEntity();
        this.oldSourceEntity = association.getSourceEntity();
    }

    public void undo() {
        this.sourceEntity.removeAssociation(this.association, true);
        this.association.setSourceEntity(this.oldSourceEntity);
        this.oldSourceEntity.addAssociation(this.association, true);
    }
}

