/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2XMLSchema;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2XMLSchemaDepType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2XMLSchemaDep
extends DB2Object<DB2XMLSchema> {
    private DB2XMLSchemaDepType xmlSchemaDepType;
    private DB2Schema depSchema;
    private String depModuleName;
    private String depModuleId;
    private String tabAuth;

    public DB2XMLSchemaDep(DB2XMLSchema db2XMLSchema, ResultSet resultSet) throws DBException {
        super(db2XMLSchema, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BNAME"), true);
        DB2ObjectType db2ObjectType;
        this.depModuleName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BMODULENAME");
        this.depModuleId = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BMODULEID");
        this.tabAuth = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABAUTH");
        String depSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"BSCHEMA");
        String depType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BTYPE");
        this.xmlSchemaDepType = (DB2XMLSchemaDepType)CommonUtils.valueOf(DB2XMLSchemaDepType.class, (String)depType);
        if (this.xmlSchemaDepType != null && (db2ObjectType = this.xmlSchemaDepType.getDb2ObjectType()) != null) {
            this.depSchema = (DB2Schema)this.getDataSource().getSchemaCache().getCachedObject(depSchemaName);
        }
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2XMLSchemaDepType getXmlSchemaDepType() {
        return this.xmlSchemaDepType;
    }

    @Property(viewable=true, editable=false, order=3)
    public DB2Schema getDepSchema() {
        return this.depSchema;
    }

    @Property(viewable=true, editable=false, order=4)
    public DBSObject getDepObject(DBRProgressMonitor monitor) throws DBException {
        if (this.xmlSchemaDepType == null || this.xmlSchemaDepType.getDb2ObjectType() == null) {
            return null;
        }
        String name = this.getName();
        if (this.depModuleName != null) {
            name = String.valueOf(this.depModuleName) + "." + name;
        }
        return this.xmlSchemaDepType.getDb2ObjectType().findObject(monitor, this.depSchema, name);
    }

    @Property(viewable=false, editable=false)
    public String getDepModuleId() {
        return this.depModuleId;
    }

    @Property(viewable=false, editable=false)
    public String getTabAuth() {
        return this.tabAuth;
    }
}

